/*
 * Decompiled with CFR 0.152.
 */
package com.testdroid.api.http;

import com.google.api.client.http.AbstractHttpContent;
import com.google.api.client.http.FileContent;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpEncoding;
import com.google.api.client.http.HttpEncodingStreamingContent;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpMediaType;
import com.google.api.client.util.Preconditions;
import com.google.api.client.util.StreamingContent;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class MultipartFormDataContent
extends AbstractHttpContent {
    private static final String NEWLINE = "\r\n";
    private static final String TWO_DASHES = "--";
    private ArrayList<Part> parts = new ArrayList();

    public MultipartFormDataContent() {
        super(new HttpMediaType("multipart/form-data").setParameter("boundary", "__END_OF_PART__"));
    }

    public void writeTo(OutputStream out) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(out, this.getCharset());
        String boundary = this.getBoundary();
        for (Part part : this.parts) {
            HttpHeaders headers = new HttpHeaders().setAcceptEncoding(null);
            if (part.headers != null) {
                headers.fromHttpHeaders(part.headers);
            }
            headers.setContentEncoding(null).setUserAgent(null).setContentType(null).setContentLength(null).set("Content-Transfer-Encoding", null);
            if (part.getName() != null) {
                String contentDisposition = String.format("form-data; name=\"%s\"", part.name);
                if (part.filename != null) {
                    contentDisposition = contentDisposition + String.format("; filename=\"%s\"", part.filename);
                }
                headers.set("Content-Disposition", (Object)contentDisposition);
            }
            HttpContent content = part.content;
            HttpContent streamingContent = null;
            if (content != null) {
                headers.setContentType(content.getType());
                headers.set("Content-Transfer-Encoding", Collections.singletonList("binary"));
                HttpEncoding encoding = part.encoding;
                if (encoding == null) {
                    streamingContent = content;
                } else {
                    headers.setContentEncoding(encoding.getName());
                    streamingContent = new HttpEncodingStreamingContent((StreamingContent)content, encoding);
                }
            }
            writer.write(TWO_DASHES);
            writer.write(boundary);
            writer.write(NEWLINE);
            HttpHeaders.serializeHeadersForMultipartRequests((HttpHeaders)headers, null, null, (Writer)writer);
            if (streamingContent == null) continue;
            writer.write(NEWLINE);
            ((Writer)writer).flush();
            streamingContent.writeTo(out);
            writer.write(NEWLINE);
        }
        writer.write(TWO_DASHES);
        writer.write(boundary);
        writer.write(TWO_DASHES);
        writer.write(NEWLINE);
        ((Writer)writer).flush();
    }

    public boolean retrySupported() {
        for (Part part : this.parts) {
            if (part.content.retrySupported()) continue;
            return false;
        }
        return true;
    }

    public MultipartFormDataContent setMediaType(HttpMediaType mediaType) {
        super.setMediaType(mediaType);
        return this;
    }

    public final Collection<Part> getParts() {
        return Collections.unmodifiableCollection(this.parts);
    }

    public MultipartFormDataContent setParts(Collection<Part> parts) {
        this.parts = new ArrayList<Part>(parts);
        return this;
    }

    public MultipartFormDataContent addPart(Part part) {
        this.parts.add((Part)Preconditions.checkNotNull((Object)part));
        return this;
    }

    public final String getBoundary() {
        return this.getMediaType().getParameter("boundary");
    }

    public MultipartFormDataContent setBoundary(String boundary) {
        this.getMediaType().setParameter("boundary", (String)Preconditions.checkNotNull((Object)boundary));
        return this;
    }

    public static final class Part {
        private HttpContent content;
        private HttpEncoding encoding;
        private String filename;
        private HttpHeaders headers;
        private String name;

        public Part() {
            this(null, null);
        }

        public Part(String name, HttpContent content) {
            this.setName(name);
            this.setContent(content);
        }

        public HttpContent getContent() {
            return this.content;
        }

        public Part setContent(HttpContent content) {
            File file;
            this.content = content;
            if (content instanceof FileContent && (file = ((FileContent)content).getFile()) != null && file.exists()) {
                this.setFilename(file.getName());
            }
            return this;
        }

        public String getName() {
            return this.name;
        }

        public Part setName(String name) {
            this.name = name;
            return this;
        }

        public String getFilename() {
            return this.filename;
        }

        public Part setFilename(String filename) {
            this.filename = filename;
            return this;
        }

        public HttpHeaders getHeaders() {
            return this.headers;
        }

        public Part setHeaders(HttpHeaders headers) {
            this.headers = headers;
            return this;
        }

        public HttpEncoding getEncoding() {
            return this.encoding;
        }

        public Part setEncoding(HttpEncoding encoding) {
            this.encoding = encoding;
            return this;
        }
    }
}

