/*
 * Decompiled with CFR 0.152.
 */
package com.testdroid.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class APISort {
    private List<SortItem> sorts;

    private APISort() {
        this(Collections.emptyList());
    }

    public APISort(List<SortItem> items) {
        this.sorts = items;
    }

    public static APISort create(List<SortItem> items) {
        return new APISort(items);
    }

    public static APISort deserialize(String value) {
        String[] resultItems;
        if (StringUtils.isBlank((CharSequence)value)) {
            return new APISort();
        }
        ArrayList<SortItem> items = new ArrayList<SortItem>();
        for (String stringItem : resultItems = value.split(":")) {
            String[] sortItemValues = stringItem.split("_");
            if (sortItemValues.length <= 1) continue;
            String column = sortItemValues[0];
            Type sortType = Type.fromURLValue(sortItemValues[1]);
            if (column == null || sortType == null) continue;
            items.add(new SortItem(column, sortType));
        }
        return new APISort(items);
    }

    public List<SortItem> getSorts() {
        return this.sorts;
    }

    public void setSorts(List<SortItem> items) {
        this.sorts = items;
    }

    public boolean isEmpty() {
        return this.sorts == null || this.sorts.isEmpty();
    }

    public String serialize() {
        return this.sorts.stream().map(SortItem::toString).collect(Collectors.joining(":"));
    }

    public String toString() {
        return this.serialize();
    }

    public static class SortItem {
        private String column;
        private Type type;

        private SortItem() {
        }

        public SortItem(String column, Type sortType) {
            this.column = column;
            this.type = sortType;
        }

        public String getColumn() {
            return this.column;
        }

        public Type getType() {
            return this.type;
        }

        public String toString() {
            return String.format("%s_%s", this.column, this.type.getURLValue());
        }
    }

    public static enum Type {
        ASC("a"),
        DESC("d");

        private final String urlValue;

        private Type(String urlValue) {
            this.urlValue = urlValue;
        }

        static Type fromURLValue(String urlValue) {
            for (Type t : Type.values()) {
                if (!t.getURLValue().equals(urlValue)) continue;
                return t;
            }
            return null;
        }

        public String getURLValue() {
            return this.urlValue;
        }
    }
}

