/*
 * Decompiled with CFR 0.152.
 */
package com.testdroid.api;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.testdroid.api.APIEntity;
import com.testdroid.api.APIException;
import com.testdroid.api.APIListResource;
import com.testdroid.api.dto.Context;
import com.testdroid.api.filter.FilterEntry;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

@XmlRootElement
@JsonIgnoreProperties(value={"id"})
public class APIList<T extends APIEntity>
extends APIEntity {
    @XmlElementWrapper
    private List<T> data;
    private Integer limit;
    private String next;
    private Integer offset;
    private String previous;
    private String search;
    private String sort;
    private Integer total;
    @JsonIgnore
    @XmlTransient
    private Context<T> context;

    public APIList() {
        this.data = new ArrayList<T>();
        this.total = 0;
    }

    public APIList(String requestURL, List<T> data, Integer total, Context<T> ctx) {
        int offset = ctx.getOffset();
        int limit = ctx.getLimit();
        String search = ctx.getSearch();
        String sort = ctx.getSort().serialize();
        this.total = total;
        this.offset = offset;
        this.limit = limit;
        this.search = search;
        this.sort = sort;
        this.data = data;
        this.context = ctx;
        String filter = APIList.filterParam(ctx.getFilters());
        if (offset + limit < total) {
            this.next = this.getListURL(requestURL, offset + limit, limit, search, sort, filter);
        }
        if (offset - limit >= 0) {
            this.previous = this.getListURL(requestURL, offset - limit, limit, search, sort, filter);
        }
    }

    private String getListURL(String requestURL, long offset, long limit, String search, String sort, String filter) {
        return String.format("%s?%s=%s&%s=%s&%s=%s&%s=%s&%s=%s", requestURL, "offset", offset, "limit", limit, "search", search, "sort", sort, "filter", filter);
    }

    public String getNext() {
        return this.next;
    }

    public void setNext(String next) {
        this.next = next;
    }

    private boolean isNextAvailable() {
        return this.offset + this.limit < this.total && !this.data.isEmpty();
    }

    @JsonIgnore
    public APIList<T> getNextItems() throws APIException {
        if (!this.isNextAvailable()) {
            return null;
        }
        return new APIListResource<T>(this.client, this.selfURI, this.context.setOffset(this.offset + this.limit)).getEntity();
    }

    private boolean isPreviousAvailable() {
        return this.offset > 0;
    }

    @JsonIgnore
    public APIList<T> getPreviousItems() throws APIException {
        if (!this.isPreviousAvailable()) {
            return null;
        }
        return new APIListResource<T>(this.client, this.selfURI, this.context.setOffset(this.offset - this.limit)).getEntity();
    }

    public String getPrevious() {
        return this.previous;
    }

    public void setPrevious(String previous) {
        this.previous = previous;
    }

    @XmlTransient
    public List<T> getData() {
        return this.data;
    }

    public void setData(List<T> data) {
        this.data = data;
    }

    public T get(int index) {
        return (T)((APIEntity)this.data.get(index));
    }

    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    public Integer getOffset() {
        return this.offset;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public Integer getTotal() {
        return this.total;
    }

    public void setTotal(Integer total) {
        this.total = total;
    }

    public String getSearch() {
        return this.search;
    }

    public void setSearch(String search) {
        this.search = search;
    }

    public String getSort() {
        return this.sort;
    }

    public void setSort(String sort) {
        this.sort = sort;
    }

    public void setContext(Context<T> context) {
        this.context = context;
    }

    @XmlTransient
    public Context<T> getContext() {
        return this.context;
    }

    @Override
    public void refresh() throws APIException {
        this.clone((S)new APIListResource<T>(this.client, this.selfURI, this.context).getEntity());
    }

    public static String filterParam(List<FilterEntry> filters) {
        return filters.stream().map(FilterEntry::toString).collect(Collectors.joining(";"));
    }

    @JsonIgnore
    protected <S extends APIEntity> void clone(S from) {
        APIList apiList = (APIList)from;
        this.cloneBase(from);
        this.data = apiList.data;
        this.limit = apiList.limit;
        this.next = apiList.next;
        this.offset = apiList.offset;
        this.previous = apiList.previous;
        this.search = apiList.search;
        this.sort = apiList.sort;
        this.total = apiList.total;
    }
}

