/*
 * Decompiled with CFR 0.152.
 */
package com.testdroid.api;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.testdroid.api.APIClient;
import com.testdroid.api.APIException;
import com.testdroid.api.APIExceptionMessage;
import com.testdroid.api.APIList;
import com.testdroid.api.APIListResource;
import com.testdroid.api.APIResource;
import com.testdroid.api.dto.Context;
import com.testdroid.api.model.APIAccessGroup;
import com.testdroid.api.model.APIAccount;
import com.testdroid.api.model.APIAccountService;
import com.testdroid.api.model.APIAccountServicePayment;
import com.testdroid.api.model.APIActivity;
import com.testdroid.api.model.APIAdminDevice;
import com.testdroid.api.model.APIAdminDeviceModel;
import com.testdroid.api.model.APIAdminDeviceProblem;
import com.testdroid.api.model.APIAdminDeviceProblemPair;
import com.testdroid.api.model.APIAdminDeviceSession;
import com.testdroid.api.model.APIAdminDeviceSessionStatistics;
import com.testdroid.api.model.APIAdminDeviceType;
import com.testdroid.api.model.APIAdminEmail;
import com.testdroid.api.model.APIAdminError;
import com.testdroid.api.model.APIAdminInteractiveDeviceSession;
import com.testdroid.api.model.APIAdminOverview;
import com.testdroid.api.model.APIAdminTestRun;
import com.testdroid.api.model.APIBillingPeriod;
import com.testdroid.api.model.APIBillingPeriodUsage;
import com.testdroid.api.model.APIBrowser;
import com.testdroid.api.model.APICloudInfo;
import com.testdroid.api.model.APICluster;
import com.testdroid.api.model.APIConnection;
import com.testdroid.api.model.APICountryVatRate;
import com.testdroid.api.model.APIDevice;
import com.testdroid.api.model.APIDeviceCleanupConfiguration;
import com.testdroid.api.model.APIDeviceFilter;
import com.testdroid.api.model.APIDeviceFilterGroup;
import com.testdroid.api.model.APIDeviceGroup;
import com.testdroid.api.model.APIDeviceModelCriterion;
import com.testdroid.api.model.APIDevicePicker;
import com.testdroid.api.model.APIDeviceProperty;
import com.testdroid.api.model.APIDeviceSession;
import com.testdroid.api.model.APIDeviceSessionDataAvailability;
import com.testdroid.api.model.APIDeviceSessionStep;
import com.testdroid.api.model.APIDeviceStatus;
import com.testdroid.api.model.APIDeviceUsage;
import com.testdroid.api.model.APIEnum;
import com.testdroid.api.model.APIFileConfig;
import com.testdroid.api.model.APIFramework;
import com.testdroid.api.model.APIHealthCheck;
import com.testdroid.api.model.APILabelGroup;
import com.testdroid.api.model.APILicense;
import com.testdroid.api.model.APIMarketShare;
import com.testdroid.api.model.APIProject;
import com.testdroid.api.model.APIProjectJobConfig;
import com.testdroid.api.model.APIProperty;
import com.testdroid.api.model.APIRole;
import com.testdroid.api.model.APIS3Url;
import com.testdroid.api.model.APIScreenshot;
import com.testdroid.api.model.APIScreenshotExtended;
import com.testdroid.api.model.APIService;
import com.testdroid.api.model.APISharedResource;
import com.testdroid.api.model.APISoftwareVersion;
import com.testdroid.api.model.APITag;
import com.testdroid.api.model.APITestCaseRun;
import com.testdroid.api.model.APITestCaseRunStep;
import com.testdroid.api.model.APITestRun;
import com.testdroid.api.model.APITestRunConfig;
import com.testdroid.api.model.APITestRunDataAvailability;
import com.testdroid.api.model.APITestRunParameter;
import com.testdroid.api.model.APIUser;
import com.testdroid.api.model.APIUserDeviceTime;
import com.testdroid.api.model.APIUserDeviceTimeSummary;
import com.testdroid.api.model.APIUserFile;
import com.testdroid.api.model.APIUserFileProperty;
import com.testdroid.api.model.APIUserFileTag;
import com.testdroid.api.model.APIUserIntegration;
import com.testdroid.api.model.APIUserStatistics;
import com.testdroid.api.model.capabilities.APIDesktopBrowserCapabilities;
import com.testdroid.api.model.devicetime.APIBasicDeviceTime;
import com.testdroid.api.model.devicetime.APIDeviceTimeCountSessionReportEntry;
import com.testdroid.api.model.jrjc.APIBasicJiraProject;
import com.testdroid.api.model.jrjc.APIJiraIssue;
import com.testdroid.api.model.jrjc.APIJiraIssueType;
import com.testdroid.api.model.jrjc.APIJiraPriority;
import com.testdroid.api.model.jrjc.APIJiraProject;
import com.testdroid.api.model.jrjc.APIJiraServerInfo;
import com.testdroid.api.model.notification.APINotification;
import com.testdroid.api.model.notification.APINotificationPlan;
import java.io.File;
import java.io.InputStream;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;

@XmlRootElement(namespace="com.testdroid.api")
@XmlSeeAlso(value={APIAccessGroup.class, APIAccount.class, APIAccountService.class, APIAccountServicePayment.class, APIActivity.class, APIAdminDevice.class, APIAdminDeviceModel.class, APIAdminDeviceProblem.class, APIAdminDeviceProblemPair.class, APIAdminDeviceSession.class, APIAdminDeviceSessionStatistics.class, APIAdminDeviceType.class, APIAdminEmail.class, APIAdminError.class, APIAdminInteractiveDeviceSession.class, APIAdminOverview.class, APIAdminTestRun.class, APIBasicDeviceTime.class, APIBasicJiraProject.class, APIBillingPeriod.class, APIBillingPeriodUsage.class, APIBrowser.class, APICloudInfo.class, APICluster.class, APIConnection.class, APICountryVatRate.class, APIDevice.class, APIDeviceCleanupConfiguration.class, APIDeviceFilter.class, APIDeviceFilterGroup.class, APIDeviceGroup.class, APIDeviceModelCriterion.class, APIDevicePicker.class, APIDeviceProperty.class, APIDeviceSession.class, APIDeviceSessionDataAvailability.class, APIDeviceSessionStep.class, APIDeviceStatus.class, APIDeviceTimeCountSessionReportEntry.class, APIDeviceUsage.class, APIDesktopBrowserCapabilities.class, APIEnum.class, APIExceptionMessage.class, APIFileConfig.class, APIFramework.class, APIHealthCheck.class, APIJiraIssue.class, APIJiraIssueType.class, APIJiraPriority.class, APIJiraProject.class, APIJiraServerInfo.class, APILabelGroup.class, APILicense.class, APIList.class, APIMarketShare.class, APINotification.class, APINotificationPlan.class, APIProject.class, APIProjectJobConfig.class, APIProperty.class, APIRole.class, APIS3Url.class, APIScreenshot.class, APIScreenshotExtended.class, APIService.class, APISharedResource.class, APISoftwareVersion.class, APITag.class, APITestCaseRun.class, APITestCaseRunStep.class, APITestRun.class, APITestRunConfig.class, APITestRunDataAvailability.class, APITestRunParameter.class, APIUser.class, APIUserDeviceTime.class, APIUserDeviceTimeSummary.class, APIUserFile.class, APIUserFileProperty.class, APIUserFileTag.class, APIUserIntegration.class, APIUserStatistics.class})
public abstract class APIEntity {
    public static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    protected APIClient client;
    protected Long id;
    protected String selfURI;
    @JsonIgnore
    protected Long parentId;

    public APIEntity() {
    }

    public APIEntity(Long id) {
        this.id = id;
    }

    @JsonIgnore
    protected static String createUri(String preUri, String postUri) {
        if (preUri.contains("?")) {
            String[] parts = preUri.split("\\?");
            return String.format("%s%s", parts[0], postUri);
        }
        return String.format("%s%s", preUri, postUri);
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getSelfURI() {
        return this.selfURI;
    }

    public void setSelfURI(String selfURI) {
        this.selfURI = selfURI;
    }

    public Long getParentId() {
        return this.parentId;
    }

    @JsonIgnore
    protected <T extends APIEntity> APIResource<T> getResource(String uri, Class<T> type) throws APIException {
        this.checkClient(this.client);
        return new APIResource<T>(this.client, uri, type);
    }

    @JsonIgnore
    protected <T extends APIEntity> APIListResource<T> getListResource(String uri, Class<T> type) throws APIException {
        this.checkClient(this.client);
        return new APIListResource<T>(this.client, uri, type);
    }

    @JsonIgnore
    protected <T extends APIEntity> APIListResource<T> getListResource(String uri, Context<T> context) throws APIException {
        this.checkClient(this.client);
        return new APIListResource<T>(this.client, uri, context);
    }

    @JsonIgnore
    protected <T extends APIEntity> T postResource(String uri, Object body, Class<T> type) throws APIException {
        this.checkClient(this.client);
        return this.client.post(uri, body, type);
    }

    @JsonIgnore
    protected <T extends APIEntity> T postFile(String uri, File file, String contentType, Class<T> type) throws APIException {
        this.checkClient(this.client);
        return this.client.postFile(uri, contentType, file, type);
    }

    @JsonIgnore
    protected void deleteResource(String uri) throws APIException {
        this.checkClient(this.client);
        this.client.delete(uri);
    }

    @JsonIgnore
    protected InputStream getFile(String uri) throws APIException {
        this.checkClient(this.client);
        return this.client.get(uri);
    }

    @JsonIgnore
    public void refresh() throws APIException {
        this.checkClient(this.client);
        this.clone((APIEntity)this.client.get(this.selfURI, this.getClass()));
    }

    @JsonIgnore
    private void checkClient(APIClient client) throws APIException {
        if (client == null) {
            throw new APIException("Missing API client");
        }
    }

    @JsonIgnore
    public String toJson() throws JsonProcessingException {
        return OBJECT_MAPPER.writeValueAsString((Object)this);
    }

    @JsonIgnore
    protected abstract <T extends APIEntity> void clone(T var1);

    @JsonIgnore
    protected <T extends APIEntity> void cloneBase(T from) {
        this.id = from.id;
    }

    static {
        OBJECT_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        OBJECT_MAPPER.configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
        OBJECT_MAPPER.registerModule((Module)new JavaTimeModule());
    }
}

