/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.management.security;

import com.terracotta.management.security.SecretProviderBackEnd;
import com.terracotta.management.security.SecretUtils;
import java.util.concurrent.atomic.AtomicReference;

public class SecretProvider {
    private static final AtomicReference<SecretProviderBackEnd> backEnd = new AtomicReference();

    public static byte[] getSecret() {
        return SecretProvider.getBackEnd().getSecret();
    }

    public static boolean fetchSecret(SecretProviderBackEnd back) {
        boolean installed;
        if (SecretProvider.isInstalled()) {
            return false;
        }
        if (back == null) {
            back = SecretUtils.newDefaultSecretProviderBackEndImpl();
        }
        if (installed = backEnd.compareAndSet(null, back)) {
            SecretProvider.getBackEnd().fetchSecret();
        }
        return installed;
    }

    static boolean isInstalled() {
        return SecretProvider.getBackEnd() != null;
    }

    static SecretProviderBackEnd getBackEnd() {
        return backEnd.get();
    }

    static void clear() {
        backEnd.set(null);
    }
}

