/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.management.user.dao.impl;

import com.terracotta.management.dao.DataAccessException;
import com.terracotta.management.security.shiro.ShiroIniFileConstants;
import com.terracotta.management.user.UserInfo;
import com.terracotta.management.user.UserRole;
import com.terracotta.management.user.dao.DatastoreNotFoundException;
import com.terracotta.management.user.dao.UserInfoDao;
import com.terracotta.management.user.impl.DfltUserInfo;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IniFileUserInfoDao
implements UserInfoDao {
    private static final String USR_HEADER = "[users]";
    private static final Pattern INVALID_USRNAME_CHARS = Pattern.compile("[=]");
    private static final Logger LOG = LoggerFactory.getLogger(IniFileUserInfoDao.class);
    private static final String LINE_SEP = System.getProperty("line.separator");
    private final File iniFile;

    public IniFileUserInfoDao() throws DataAccessException {
        this(new File(System.getProperty("com.tc.management.security.ini") == null ? ShiroIniFileConstants.DFLT_INI_FILE_LOCATION : System.getProperty("com.tc.management.security.ini")));
    }

    public IniFileUserInfoDao(File iniFile) throws DataAccessException {
        this(iniFile, true);
    }

    public IniFileUserInfoDao(File iniFile, boolean createFile) throws DataAccessException {
        this.iniFile = iniFile;
        if (createFile && !this.iniFile.exists()) {
            this.initIniFile();
        }
    }

    @Override
    public UserInfo getById(final String username) throws DataAccessException {
        final AtomicReference<Object> usrRef = new AtomicReference<Object>(null);
        SynchronizedFileLockingTask task = new SynchronizedFileLockingTask(){

            @Override
            void doWork() throws DataAccessException, IOException {
                long cSize = this.fileChannel.size();
                ByteBuffer mbb = ByteBuffer.allocate((int)cSize);
                this.fileChannel.read(mbb);
                mbb.flip();
                int p = IniFileUserInfoDao.this.findUserPosition(username, mbb);
                if (p > -1) {
                    byte b;
                    mbb.position(p);
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    while ((b = mbb.get()) != LINE_SEP.charAt(0)) {
                        baos.write(b);
                    }
                    usrRef.set(IniFileUserInfoDao.buildUserInfo(new String(baos.toByteArray())));
                }
            }

            @Override
            String getWorkDescription() {
                return String.format("Retrieving user with id '%s'", username);
            }
        };
        task.execute();
        return usrRef.get();
    }

    @Override
    public synchronized void create(final UserInfo user) throws DataAccessException {
        SynchronizedFileLockingTask task = new SynchronizedFileLockingTask(){

            @Override
            void doWork() throws DataAccessException, IOException {
                long fcSize = this.fileChannel.size();
                ByteBuffer mbb = ByteBuffer.allocate((int)fcSize);
                this.fileChannel.read(mbb);
                mbb.flip();
                if (IniFileUserInfoDao.this.findUserPosition(user.getUsername(), mbb) <= -1) {
                    String line = IniFileUserInfoDao.buildNewUserLine(user);
                    this.fileChannel.position(fcSize);
                    ByteBuffer bb = ByteBuffer.wrap(line.getBytes());
                    while (bb.hasRemaining()) {
                        this.fileChannel.write(bb);
                    }
                }
            }

            @Override
            String getWorkDescription() {
                return String.format("Create user %s", user);
            }
        };
        task.execute();
    }

    @Override
    public void createOrUpdate(final UserInfo user) throws DataAccessException {
        SynchronizedFileLockingTask task = new SynchronizedFileLockingTask(){

            @Override
            void doWork() throws DataAccessException, IOException {
                IniFileUserInfoDao.this.update(this.fileChannel, user, true);
            }

            @Override
            String getWorkDescription() {
                return String.format("Creating or updating user %s", user);
            }
        };
        task.execute();
    }

    @Override
    public void delete(final UserInfo user) throws DataAccessException {
        SynchronizedFileLockingTask task = new SynchronizedFileLockingTask(){

            @Override
            void doWork() throws DataAccessException, IOException {
                IniFileUserInfoDao.this.update(this.fileChannel, user, false);
            }

            @Override
            String getWorkDescription() {
                return String.format("Deleting user %s", user);
            }
        };
        task.execute();
    }

    @Override
    public void flush() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void evict(UserInfo user) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasUserInfos() throws DataAccessException {
        final AtomicBoolean available = new AtomicBoolean(false);
        SynchronizedFileLockingTask task = new SynchronizedFileLockingTask(){

            @Override
            void doWork() throws DataAccessException, IOException {
                long fcSize = this.fileChannel.size();
                ByteBuffer mbb = ByteBuffer.allocate((int)fcSize);
                this.fileChannel.read(mbb);
                mbb.flip();
                if (mbb.compareTo(ByteBuffer.wrap((IniFileUserInfoDao.USR_HEADER + LINE_SEP).getBytes())) > 0) {
                    available.set(true);
                }
            }

            @Override
            String getWorkDescription() {
                return String.format("Determining whether datastore has any UserInfo objects available", new Object[0]);
            }
        };
        task.execute();
        return available.get();
    }

    @Override
    public void truncate() throws DataAccessException {
        SynchronizedFileLockingTask task = new SynchronizedFileLockingTask(){

            @Override
            void doWork() throws DataAccessException, IOException {
                this.fileChannel.truncate(0L);
                ByteBuffer byteBuffer = ByteBuffer.wrap((IniFileUserInfoDao.USR_HEADER + LINE_SEP).getBytes());
                while (byteBuffer.hasRemaining()) {
                    this.fileChannel.write(byteBuffer);
                }
            }

            @Override
            String getWorkDescription() {
                return String.format("Truncating UserInfo datastore", new Object[0]);
            }
        };
        task.execute();
    }

    @Override
    public synchronized void validate(boolean establish) throws DataAccessException {
        if (!this.iniFile.exists()) {
            if (establish) {
                this.initIniFile();
            } else {
                throw new DatastoreNotFoundException();
            }
        }
    }

    private static String buildNewUserLine(UserInfo userInfo) throws DataAccessException {
        Matcher m = INVALID_USRNAME_CHARS.matcher(userInfo.getUsername());
        if (m.find()) {
            throw new DataAccessException(String.format("Invalid username '%s' detected! Unable to update datastore.", userInfo.getUsername()));
        }
        StringBuilder sb = new StringBuilder(userInfo.getUsername());
        sb.append("=").append(userInfo.getPasswordHash());
        Set<UserRole> roles = userInfo.getRoles();
        if (roles != null) {
            Iterator<UserRole> rItr = roles.iterator();
            do {
                sb.append(",").append(rItr.next().toString());
            } while (rItr.hasNext());
        }
        sb.append(LINE_SEP);
        return sb.toString();
    }

    private static UserInfo buildUserInfo(String iniEntry) {
        String[] components = iniEntry.split(",");
        String[] credentials = components[0].split("=", 2);
        HashSet<UserRole> roles = null;
        for (int i = 1; i < components.length; ++i) {
            if (roles == null) {
                roles = new HashSet<UserRole>();
            }
            roles.add(UserRole.byName(IniFileUserInfoDao.trimToNull(components[i])));
        }
        return new DfltUserInfo(IniFileUserInfoDao.trimToNull(credentials[0]), IniFileUserInfoDao.trimToNull(credentials[1]), roles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initIniFile() throws DataAccessException {
        File parent = this.iniFile.getParentFile();
        if (parent != null && !parent.exists() && !parent.mkdirs()) {
            throw new DataAccessException(String.format("Failed to create parent folders for ini file: %s", this.iniFile.getParentFile().getAbsolutePath()));
        }
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(this.iniFile, false));
            try {
                writer.write(USR_HEADER + LINE_SEP);
            }
            finally {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    LOG.warn("Failed to close FileWriter creating new security ini file.");
                }
            }
        }
        catch (IOException e) {
            if (this.iniFile.exists()) {
                this.iniFile.delete();
            }
            throw new DataAccessException("Failure writing new security ini file.", e);
        }
    }

    private void update(FileChannel fc, UserInfo user, boolean replace) throws IOException, DataAccessException {
        long cSize = fc.size();
        ByteBuffer mbb = ByteBuffer.allocate((int)cSize);
        fc.read(mbb);
        mbb.flip();
        int p = this.findUserPosition(user.getUsername(), mbb);
        mbb.position(p == -1 ? 0 : p);
        UserInfo thisUser = null;
        if (p > -1) {
            byte b;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            while ((b = mbb.get()) != LINE_SEP.charAt(LINE_SEP.length() - 1)) {
                baos.write(b);
            }
            thisUser = IniFileUserInfoDao.buildUserInfo(new String(baos.toByteArray()));
        }
        byte[] tail = null;
        if (replace || user.equals(thisUser)) {
            if (p > -1) {
                int end = mbb.position();
                tail = new byte[(int)cSize - end];
                mbb.get(tail);
                fc.truncate(p);
                fc.position(fc.size());
            } else {
                fc.position(cSize);
            }
            if (replace) {
                ByteBuffer bbReplace = ByteBuffer.wrap(IniFileUserInfoDao.buildNewUserLine(user).getBytes());
                while (bbReplace.hasRemaining()) {
                    fc.write(bbReplace);
                }
            }
            if (tail != null) {
                ByteBuffer bbTail = ByteBuffer.wrap(tail);
                while (bbTail.hasRemaining()) {
                    fc.write(bbTail);
                }
            }
        }
    }

    private int findUserPosition(String username, ByteBuffer buffer) throws IOException {
        int pos = -1;
        byte[] matchMe = (username + "=").getBytes();
        byte[] forMatch = null;
        int count = 0;
        while (buffer.hasRemaining()) {
            byte b = buffer.get();
            if (LINE_SEP.length() == 2 && b == LINE_SEP.charAt(1) || b == LINE_SEP.charAt(0)) {
                forMatch = new byte[matchMe.length];
                continue;
            }
            if (count == matchMe.length) {
                if (Arrays.equals(matchMe, forMatch)) {
                    pos = buffer.position() - matchMe.length - 1;
                    break;
                }
                forMatch = null;
                count = 0;
                continue;
            }
            if (forMatch == null) continue;
            forMatch[count++] = b;
        }
        return pos;
    }

    private static String trimToNull(String string) {
        return string == null || string.trim().length() == 0 ? null : string.trim();
    }

    private abstract class SynchronizedFileLockingTask {
        private final Logger TASK_LOG = LoggerFactory.getLogger(SynchronizedFileLockingTask.class);
        protected FileChannel fileChannel;

        private SynchronizedFileLockingTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void execute() throws DataAccessException {
            try {
                RandomAccessFile raf = new RandomAccessFile(IniFileUserInfoDao.this.iniFile, "rw");
                this.fileChannel = raf.getChannel();
                try {
                    FileLock lock = this.fileChannel.lock();
                    try {
                        this.doWork();
                    }
                    catch (Throwable throwable) {
                        try {
                            lock.release();
                        }
                        catch (IOException e) {
                            this.TASK_LOG.warn(String.format("[%s]: Failure to release lock.", this.getWorkDescription()));
                        }
                        throw throwable;
                    }
                    try {
                        lock.release();
                    }
                    catch (IOException e) {
                        this.TASK_LOG.warn(String.format("[%s]: Failure to release lock.", this.getWorkDescription()));
                    }
                }
                catch (Throwable throwable) {
                    try {
                        this.fileChannel.close();
                    }
                    catch (IOException e) {
                        this.TASK_LOG.warn(String.format("[%s]: Failure to close FileChannel.", this.getWorkDescription()));
                    }
                    try {
                        raf.close();
                    }
                    catch (IOException e) {
                        this.TASK_LOG.warn(String.format("[%s]: Failure to close IniFile.", this.getWorkDescription()));
                    }
                    throw throwable;
                }
                try {
                    this.fileChannel.close();
                }
                catch (IOException e) {
                    this.TASK_LOG.warn(String.format("[%s]: Failure to close FileChannel.", this.getWorkDescription()));
                }
                try {
                    raf.close();
                }
                catch (IOException e) {
                    this.TASK_LOG.warn(String.format("[%s]: Failure to close IniFile.", this.getWorkDescription()));
                }
            }
            catch (IOException e) {
                throw new DataAccessException(String.format("[%s]: Failed to handle request.", this.getWorkDescription()), e);
            }
        }

        abstract void doWork() throws DataAccessException, IOException;

        abstract String getWorkDescription();
    }
}

