/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.management.security.shiro.realm;

import com.terracotta.management.security.IACredentials;
import com.terracotta.management.security.IdentityAssertionServiceClient;
import com.terracotta.management.security.InvalidIAInteractionException;
import com.terracotta.management.security.shiro.IdentityAssertionToken;
import com.terracotta.management.user.UserInfo;
import com.terracotta.management.user.UserRole;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.SimplePrincipalCollection;
import org.apache.shiro.util.CollectionUtils;
import org.apache.shiro.util.StringUtils;
import org.terracotta.management.ServiceLocator;

public class TCIdentityAssertionRealm
extends AuthorizingRealm {
    private static final String OPERATOR_PERM = "api:read";
    private static final Collection<String> ADMIN_PERMS = Arrays.asList("api:update", "api:create", "api:delete");
    private final IdentityAssertionServiceClient iaClient;

    public TCIdentityAssertionRealm() throws URISyntaxException, MalformedURLException {
        this((IdentityAssertionServiceClient)ServiceLocator.locate(IdentityAssertionServiceClient.class));
    }

    public TCIdentityAssertionRealm(IdentityAssertionServiceClient idAssertionSvcClient) throws URISyntaxException, MalformedURLException {
        this.iaClient = idAssertionSvcClient;
        this.setAuthenticationTokenClass(IdentityAssertionToken.class);
        this.setCachingEnabled(false);
        this.setAuthenticationCachingEnabled(false);
    }

    protected void onInit() {
        super.onInit();
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {
        UserInfo user;
        if (token == null) {
            return null;
        }
        IdentityAssertionToken iaToken = (IdentityAssertionToken)token;
        IACredentials credentials = (IACredentials)iaToken.getCredentials();
        if (!StringUtils.hasText((String)credentials.getIdentityToken())) {
            return null;
        }
        try {
            user = this.iaClient.retreiveUserDetail(credentials);
        }
        catch (InvalidIAInteractionException e) {
            throw new AuthenticationException((Throwable)e);
        }
        iaToken.setPrincipal(user.getUsername());
        List principals = CollectionUtils.asList((Object[])new Object[]{user.getUsername(), user.getRoles()});
        SimplePrincipalCollection principalCollection = new SimplePrincipalCollection((Collection)principals, this.getName());
        return new SimpleAuthenticationInfo((PrincipalCollection)principalCollection, (Object)credentials);
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        SimplePrincipalCollection principalCollection = (SimplePrincipalCollection)principals;
        List listPrincipals = principalCollection.asList();
        Set roles = (Set)listPrincipals.get(1);
        SimpleAuthorizationInfo sai = new SimpleAuthorizationInfo();
        for (UserRole r : roles) {
            sai.addRole(r.toString());
            if (r == UserRole.ADMIN) {
                sai.addStringPermissions(ADMIN_PERMS);
                continue;
            }
            if (r != UserRole.OPERATOR) continue;
            sai.addStringPermission(OPERATOR_PERM);
        }
        return sai;
    }
}

