package com.tenqube.visual_third.api;

import com.tenqube.visual_third.model.api.AdResponse;
import com.tenqube.visual_third.model.api.CurrencyResponse;
import com.tenqube.visual_third.model.api.SearchCompanyRequest;
import com.tenqube.visual_third.model.api.SearchCompanyResponse;
import com.tenqube.visual_third.model.api.SignUpRequest;
import com.tenqube.visual_third.model.api.SignUpResponse;
import com.tenqube.visual_third.model.api.TransactionRequest;

import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.POST;
import retrofit2.http.Path;
import retrofit2.http.Url;

interface VisualApiService {

    String RICH_N_CO = "https://richnco.tenqube.kr/";

    @POST("users/sign-up")
    Call<SignUpResponse> signUp(@Header("x-api-key") String apiKey, @Body SignUpRequest signUp);

    @GET("currency/rate/{from}/{to}")
    Call<CurrencyResponse> callCurrencyRate(@Header("x-api-key") String apiKey, @Header("Authorization") String authorization, @Path("from") String from, @Path("to") String to);

    @POST("transaction")
    Call<Void> saveTransactions(@Header("x-api-key") String apiKey, @Header("Authorization") String authorization, @Body TransactionRequest transactionRequest);

    @POST
    Call<SearchCompanyResponse> searchCompany(@Header("x-api-key") String apiKey, @Header("Authorization") String authorization, @Url String url, @Body SearchCompanyRequest searchCompanyRequest);

    @GET("ad/{where}")
    Call<AdResponse> getAds(@Header("x-api-key") String apiKey, @Path("where") String where);
}
