package com.tenqube.visual_third.ui;

import android.annotation.SuppressLint;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Typeface;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.content.ContextCompat;
import android.support.v4.widget.SwipeRefreshLayout;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import android.widget.ProgressBar;
import android.widget.TextView;

import com.tenqube.visual_third.Callback;
import com.tenqube.visual_third.Constants;
import com.tenqube.visual_third.R;
import com.tenqube.visual_third.VisualServiceImpl;
import com.tenqube.visual_third.analysis.AnalysisServiceImpl;
import com.tenqube.visual_third.api.VisualApi;
import com.tenqube.visual_third.manager.AnswerManager;
import com.tenqube.visual_third.manager.PrefManager;
import com.tenqube.visual_third.manager.ResourceManager;
import com.tenqube.visual_third.manager.VisualAlarmManager;
import com.tenqube.visual_third.manager.bulk.BulkParsingManager;
import com.tenqube.visual_third.manager.bulk.BulkParsingManagerImpl;
import com.tenqube.visual_third.model.api.SignUpRequest;
import com.tenqube.visual_third.model.api.SignUpResponse;
import com.tenqube.visual_third.model.js.DateRequest;
import com.tenqube.visual_third.model.js.LogRequest;
import com.tenqube.visual_third.model.js.TimeRequest;
import com.tenqube.visual_third.repository.VisualRepository;
import com.tenqube.visual_third.util.FontUtil;
import com.tenqube.visual_third.util.permission.PermissionUtil;
import com.tenqube.visual_third.web.ErrorImpl;
import com.tenqube.visual_third.web.LogImpl;
import com.tenqube.visual_third.web.RepoImpl;
import com.tenqube.visual_third.web.SystemImpl;
import com.tenqube.visual_third.web.UiImpl;
import com.tenqube.visual_third.web.ViewContractor;
import com.tenqube.visual_third.web.VisualInterface;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.List;

import static android.app.Activity.RESULT_CANCELED;
import static android.app.Activity.RESULT_OK;
import static com.tenqube.visual_third.manager.AnswerManager.initFabric;
import static com.tenqube.visual_third.manager.PrefManager.UID;
import static com.tenqube.visual_third.util.FontUtil.getFont;
import static com.tenqube.visual_third.util.FontUtil.setAllTextView;
import static com.tenqube.visual_third.util.Utils.changeStatusColor;
import static com.tenqube.visual_third.util.Utils.isNotiEnabled;
import static com.tenqube.visual_third.util.WebViewHelper.getBaseUrl;
import static com.tenqube.visual_third.util.WebViewHelper.settings;
import static tenqube.parser.core.ParserService.mIsDebug;
import static tenqube.parser.util.LogUtil.LOGI;

public class VisualActivityFragment extends Fragment implements TimePickerFragment.Callback,
        DatePickerFragment.Callback,
        ViewContractor,
        NotificationDialogFragment.Callback, PermissionUtil.PermissionCallbacks {

    public static final String TAG = VisualServiceImpl.class.getSimpleName();
    public static final String ARG_UID = "UID";
    public static final String ARG_PATH = "PATH";
    public static final int POPUP_CODE = 1000;

    public static final int FINISH = 10;
    public static final int PROGRESS = 11;
    public static final int NOTIFICATION_REQUEST_CODE = 10;

    private VisualRepository repository;
    private ResourceManager resourceManager;
    private PrefManager prefManager;
    private VisualAlarmManager alarmManager;
    private VisualApi api;
    private String mFailingUrl;

    private WebView webview;

    private VisualInterface.Repo repoInterface;
    private VisualInterface.UI uiInterface;
    private VisualInterface.System systemInterface;
    private VisualInterface.Error errorInterface;
    private VisualInterface.Log logInterface;

    private SwipeRefreshLayout swipeRefreshLayout;

    private boolean isPageLoaded;

    private OnFragBackListener listener;
    private FrameLayout bulkContainer;

    private ProgressBar progressBar;

    private String uid;
    private String path;

    private BulkParsingManager bulkParsingManager;
    private FrameLayout errorView;
    private boolean isError;

    private  boolean shouldShowNotiPopup;

    public VisualActivityFragment() {
        // Required empty public constructor
    }

    public static VisualActivityFragment newInstance(String uid, String path) {

        VisualActivityFragment fragment = new VisualActivityFragment();
        Bundle bundle = new Bundle();
        bundle.putString(ARG_UID, uid);
        bundle.putString(ARG_PATH, path);

        fragment.setArguments(bundle);
        return fragment;
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setRetainInstance(true);

        if(getArguments() != null) {
            uid = getArguments().getString(ARG_UID, "");
            path = getArguments().getString(ARG_PATH, "");
            if(path == null) {
                path = "";
            }
        }

        api = VisualApi.getInstance(getActivity());
        prefManager = PrefManager.getInstance(getActivity());
        resourceManager = ResourceManager.getInstance(api, prefManager);
        repository = VisualRepository.getInstance(getActivity());
        alarmManager = VisualAlarmManager.getInstance(getActivity());
        initFabric(getActivity());
        AnswerManager.onKeyMetric(new LogRequest("VisualActivityFragment"));
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.fragment_visual_web, container, false);
        setAllTextView(view);
        return view;
    }

    @SuppressLint("AddJavascriptInterface")
    @Override
    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        try {
            progressBar = (ProgressBar) view.findViewById(R.id.progress_bar);
            progressBar.setVisibility(View.GONE);

            errorView = view.findViewById(R.id.error_container);
            errorView.setVisibility(View.GONE);
            view.findViewById(R.id.retry).setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    retry();
                }
            });

            swipeRefreshLayout = (SwipeRefreshLayout) view.findViewById(R.id.swipe_refresh_layout);
            swipeRefreshLayout.setEnabled(false);
            swipeRefreshLayout.setColorSchemeResources(
                    R.color.colorPopupRed,
                    R.color.colorPopupRed,
                    R.color.colorPopupRed);

            swipeRefreshLayout.setOnRefreshListener(new SwipeRefreshLayout.OnRefreshListener() {
                @Override
                public void onRefresh() {

                    if(progressBar != null) progressBar.setVisibility(View.GONE);
                    swipeRefreshLayout.setRefreshing(false);
                    webview.reload();
                }
            });

            webview = (WebView) view.findViewById(R.id.visual_web_view);
            webview.setBackgroundColor(ContextCompat.getColor(getActivity(), R.color.colorWebView));
            webview.getSettings().setTextZoom(100);//font size

            // javascriptInterface
            errorInterface = new ErrorImpl(getActivity(), this, webview);
            logInterface = new LogImpl(getActivity(), this, webview, errorInterface);

            repoInterface = new RepoImpl(getActivity(), this, webview, errorInterface,
                    VisualRepository.getInstance(getActivity()),
                    api,
                    new AnalysisServiceImpl(getActivity(), prefManager.loadStringValue(PrefManager.QUALIFIER, Constants.DEV)),
                    alarmManager);

            uiInterface = new UiImpl(getActivity(), this, webview, errorInterface, new BottomDialog(getActivity()));
            systemInterface = new SystemImpl(getActivity(), this, webview, errorInterface);

            webview.addJavascriptInterface(errorInterface, "visualError");
            webview.addJavascriptInterface(repoInterface, "visualRepo");
            webview.addJavascriptInterface(uiInterface, "visualUI");
            webview.addJavascriptInterface(systemInterface, "visualSystem");
            webview.addJavascriptInterface(logInterface, "visualLog");

            // settings
            settings(webview);

            // error
            webview.setWebViewClient(new WebViewClient() {
                public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
                    isError = true;
                    mFailingUrl = failingUrl;
                    if(progressBar != null) progressBar.setVisibility(View.GONE);
                    loadErrorUrl();
                }

                @Override
                public void onPageStarted(WebView view, String url, Bitmap favicon) {
                    super.onPageStarted(view, url, favicon);
                    if(progressBar != null) progressBar.setVisibility(View.VISIBLE);
                }

                @Override
                public void onPageCommitVisible(WebView view, String url) {
                     if(progressBar != null) progressBar.setVisibility(View.GONE);

                    super.onPageCommitVisible(view, url);
                }

                @Override
                public void onPageFinished(WebView view, String url) {

                    if (!isError) errorView.setVisibility(View.GONE);
                    isError = false;
                    super.onPageFinished(view, url);
                    if(progressBar != null) progressBar.setVisibility(View.GONE);

                    if(shouldShowNotiPopup) {
                        shouldShowNotiPopup = false;
                        if(!isNotiEnabled(getActivity())) {
                            if(isNotShown()) {
                                showNotiCatch();
                                repository.setIsNotShown(false);

                            }
                        }
                    }
                }
            });

            if(prefManager.loadStringValue(PrefManager.QUALIFIER, Constants.DEV).equals(Constants.DEV))
                webview.getSettings().setCacheMode(WebSettings.LOAD_NO_CACHE);

            bulkContainer = (FrameLayout) view.findViewById(R.id.start_bulk);
            bulkContainer.setVisibility(View.GONE);
            TextView bulkTextView = view.findViewById(R.id.start_bulk_txt);
            Typeface typeface = getFont(getContext(), FontUtil.REGULAR);
            if(typeface != null)
                bulkTextView.setTypeface(typeface);

            Log.i("Visual", "UID" + prefManager.loadStringValue(PrefManager.UID, ""));

            if (TextUtils.isEmpty(prefManager.loadStringValue(PrefManager.UID, ""))) {
                bulkContainer.setVisibility(View.VISIBLE);

                setAllTextView(bulkContainer);

                webview.loadUrl(String.format("http://%1$s.richnco-view.tenqube.kr/v2/intro/", prefManager.loadStringValue(PrefManager.QUALIFIER, "dev")));

                bulkContainer.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        signUp();
                    }
                });
            } else {
                resourceManager.sync();

                alarmManager.setAlarms();

//                if (!TextUtils.isEmpty(path))
//                    startPopup(path);

                // 웹 가계부 호출
                shouldShowNotiPopup = true;
                startBulk();

            }

        } catch(Exception e) {
            if(getActivity() != null)
                getActivity().finish();
        }
    }

    private boolean isNotShown() {
        return repository.isNotShown();
    }

    private void signUp() {
        signUp(uid, new OnResultListener() {
            @Override
            public void onResult(final int signUpResult, final String msg) {

                if(getActivity() != null) {
                    getActivity().runOnUiThread(new Runnable() {
                        @Override
                        public void run() {
                            if(signUpResult == Constants.SignupResult.FAIL) {
                                loadErrorUrl();
                            } else {
                                Log.i("Visual", "BULK_EXECUTED" + prefManager.isEnabled(PrefManager.BULK_EXECUTED, false));
                                startBulk();
                            }
                        }
                    });
                }
            }
        });
    }

    private void startBulk() {
        if (!prefManager.isEnabled(PrefManager.BULK_EXECUTED, false)){
            bulkParsingManager = new BulkParsingManagerImpl(VisualActivityFragment.this);

            bulkParsingManager.start(new Callback<Boolean>() {
                @Override
                public void onComplete(Boolean value) {

                    shouldShowNotiPopup = true;
                    prefManager.saveBoolean(PrefManager.BULK_EXECUTED, value);
                    loadUrl();

                }
            });
        } else {
            shouldShowNotiPopup = true;
            loadUrl();
        }
    }

    @Override
    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        if(getActivity() != null)
            changeStatusColor(getActivity(), R.color.colorStatusBar);
    }

    private void loadUrl() {

        bulkContainer.setVisibility(View.GONE);
        if(webview != null) {
            isPageLoaded = false;

            String url = getBaseUrl(prefManager, path);
            LOGI(TAG, "loadUrl" + url, mIsDebug);
            webview.loadUrl(url);
        }
    }

    private void signUp(@NonNull final String uid, @NonNull final OnResultListener onResultListener) {
        Log.i(TAG, "가입");

        final SignUpRequest signUpRequest = new SignUpRequest(uid);
        Log.i(TAG, "가입 ID" + prefManager.loadStringValue(UID, ""));

        if(!TextUtils.isEmpty(prefManager.loadStringValue(UID, ""))) {
            onResultListener.onResult(Constants.SignupResult.ALREADY_JOINED, "already joined");
            return;
        }

        AnswerManager.onKeyMetric(new LogRequest("signUp"));
        new Thread(new Runnable() {
            @Override
            public void run() {

                try {
                    SignUpResponse response = api.signUp(signUpRequest);
                    Log.i(TAG, "가입 ID" + response.toString());

                    if (response == null) {
                        onResultListener.onResult(Constants.SignupResult.FAIL, "network error");
                    } else {

                        repository.saveServerInfo(response);

                        onResultListener.onResult(Constants.SignupResult.SUCCESS, "success");
                    }
                } catch (Exception e) {
                    onResultListener.onResult(Constants.SignupResult.FAIL, e.toString());
                }
            }
        }).start();

    }

    private void loadErrorUrl() {
        isPageLoaded = false;
        if(swipeRefreshLayout != null) swipeRefreshLayout.setEnabled(false);
        errorView.setVisibility(View.VISIBLE);
    }

    @Override
    public void onCalendar(String date, String callback) {
        uiInterface.onCalendar(date, callback);
    }

    @Override
    public void onPageLoaded() {
        if(getActivity() != null) getActivity().runOnUiThread(new Runnable() {
            @Override
            public void run() {
                isPageLoaded = true;
            }
        });
    }

    @Override
    public void setRefreshEnabled(final boolean enabled) {

        try {
            if(getActivity() != null)
                getActivity().runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        swipeRefreshLayout.setEnabled(enabled);
                    }
                });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void showDatePicker(DateRequest dateRequest) {
        if(getActivity() != null) {
            DialogFragment newFragment = DatePickerFragment.newInstance(dateRequest);

            FragmentManager fragmentManager = getFragmentManager();
            if(fragmentManager != null) {
                fragmentManager.beginTransaction().add(newFragment, "datePicker").commitAllowingStateLoss();
            }
        }
    }

    @Override
    public void showTimePicker(TimeRequest timeRequest) {
        if(getActivity() != null) {
            DialogFragment newFragment = TimePickerFragment.newInstance(timeRequest);

            FragmentManager fragmentManager = getFragmentManager();
            if(fragmentManager != null) {
                fragmentManager.beginTransaction().add(newFragment, "timePicker").commitAllowingStateLoss();
            }
        }
    }

    @Override
    public void onFinish(String path) {

        Log.i("onFinish", path);

        if(getActivity() != null) {
            Intent intent = getActivity().getIntent();
            getActivity().setResult(TextUtils.isEmpty(path) || "false".equals(path) ?
                    RESULT_CANCELED
                    :
                    RESULT_OK, intent);

            listener.onFragBackPressed();
        }

    }

    @Override
    public void startPopup(String path) {

        Intent intent = new Intent(getActivity(), VisualWebActivity.class);
        intent.putExtra(ARG_PATH, path);
        intent.putExtra(ARG_UID, uid);
        startActivityForResult(intent, POPUP_CODE);
    }

    @Override
    public void showNotiCatch() {
        if(getActivity() != null) {
            NotificationDialogFragment dialogFragment = NotificationDialogFragment.newInstance();
            dialogFragment.setCallback(this);
            FragmentManager fragmentManager = getFragmentManager();

            if(fragmentManager != null && !dialogFragment.isAdded() && fragmentManager.findFragmentByTag(NotificationDialogFragment.TAG) == null) {

                fragmentManager.beginTransaction().add(dialogFragment, NotificationDialogFragment.TAG).commitAllowingStateLoss();
            }
        }

    }

    @Override
    public void goNotiSettings() throws ActivityNotFoundException {
        if(getActivity() != null) {
            Intent intent = new Intent("android.settings.ACTION_NOTIFICATION_LISTENER_SETTINGS");
            startActivityForResult(intent, NOTIFICATION_REQUEST_CODE);
        }
    }

    @Override
    public void reload() {
        if(webview != null)  {
            webview.post(new Runnable() {
                @Override
                public void run() {
                    webview.reload();
                }
            });
        }
    }

    @Override
    public void retry() {
        if(webview != null)  {
            webview.post(new Runnable() {
                @Override
                public void run() {
                    webview.loadUrl(mFailingUrl);
                }
            });
        }
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, Intent data) {

        Log.i("onFinish", "onActivityResult");

        try {
            switch (requestCode) {
                case NOTIFICATION_REQUEST_CODE:
                    boolean isEnabled = isNotiEnabled(getActivity());

                    JSONObject jsonObject = new JSONObject();
                    try {
                        jsonObject.put("isNotiEnabled", isEnabled);
                        String json = jsonObject.toString();
                        if(systemInterface != null) systemInterface.onNotiCallback(json);
                    } catch (JSONException e) {
                        e.printStackTrace();
                    }
                    break;

                case POPUP_CODE:
                    if(resultCode == RESULT_OK) {
                        reload();
                    }
                    break;
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    public void onBackPressed() {
        try {
            if(isPageLoaded && uiInterface != null) {
                uiInterface.onFinish();
            } else {
                onFragBackPressed();
            }
        } catch (Exception e) {
            onFragBackPressed();
        }
    }

    public void onFragBackPressed() {
        if(listener != null) listener.onFragBackPressed();
    }

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);
        if (context instanceof VisualActivityFragment.OnFragBackListener) {
            listener = (VisualActivityFragment.OnFragBackListener) context;
        } else {
            throw new RuntimeException(context.toString()
                    + " must implement OnFragBackListener");
        }
    }

    @Override
    public void onDetach() {
        super.onDetach();
        listener = null;
    }

    @Override
    public void onOkButtonClicked() {
        goNotiSettings();
    }

    @Override
    public void onCancelButtonClicked() {

    }

    @Override
    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);

        // Forward results to EasyPermissions
        PermissionUtil.onRequestPermissionsResult(requestCode, permissions, grantResults, this);
    }

    @Override
    public void onPermissionsGranted(int requestCode, List<String> perms) {
        bulkParsingManager.onPermissionGranted();
    }

    @Override
    public void onPermissionsDenied(int requestCode, List<String> perms) {
        bulkParsingManager.onPermissionsDenied();

    }

    public interface OnFragBackListener {
        void onFragBackPressed();
    }

}
