package com.tenqube.visual_third.ui;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.v4.app.FragmentTransaction;
import android.support.v7.app.AppCompatActivity;

import com.tenqube.visual_third.R;

import static com.tenqube.visual_third.ui.VisualActivityFragment.ARG_PATH;
import static com.tenqube.visual_third.ui.VisualActivityFragment.ARG_UID;
import static com.tenqube.visual_third.util.Utils.changeStatusColor;

public class VisualWebActivity extends AppCompatActivity implements VisualActivityFragment.OnFragBackListener {

    public static final String ACTION_INITIALIZE = "ACTION_INITIALIZE";

    @Override
    protected void onCreate(Bundle savedInstanceState) {

        changeStatusColor(VisualWebActivity.this, android.R.color.white);
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_visual_web);

        if (savedInstanceState == null) {
            FragmentTransaction transaction = getSupportFragmentManager().beginTransaction();
            transaction.replace(R.id.container, VisualActivityFragment.newInstance(getIntent().getStringExtra(ARG_UID),
                    getIntent().getStringExtra(ARG_PATH)));
            transaction.commit();
        }
    }

    public static void startActivity(Context context, String uid, String path) {

        Intent intent = new Intent(context, VisualWebActivity.class);

        intent.putExtra(ARG_UID, uid);

        intent.putExtra(ARG_PATH, path);

        context.startActivity(intent);

    }

    @Override
    public void startActivityForResult(Intent intent, int requestCode) {
        super.startActivityForResult(intent, requestCode);
        overridePendingTransition(R.anim.slide_in_down, R.anim.stay);

    }

    @Override
    public void startActivity(Intent intent) {
        super.startActivity(intent);
        overridePendingTransition(R.anim.slide_in_down, R.anim.stay);

    }

    @Override
    public void finish() {
        super.finish();
        overridePendingTransition(R.anim.stay, R.anim.slide_out_down);
    }

    @Override
    public void onFragBackPressed() {
        finish();
    }
}
