package com.tenqube.visual_third.parser.catcher;

import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteException;
import android.net.Uri;
import android.text.TextUtils;

import com.tenqube.visual_third.util.Utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Calendar;

import tenqube.parser.constants.Constants;
import tenqube.parser.model.SMS;

public class MMSHelper {

    private Context mContext;

    public MMSHelper(Context mContext) {
        this.mContext = mContext;
    }

    public SMS getMMS() {

        Cursor mmsCursor = null;
        try {
            Uri mmsUri = Uri.parse("content://mms/inbox");
            mmsCursor = mContext.getContentResolver().query(mmsUri, null, "msg_box = 1", null, "_id desc limit 1");
            if(mmsCursor!=null) {
                if (mmsCursor.moveToFirst()) {

                    int id = mmsCursor.getInt(mmsCursor.getColumnIndex("_id"));
                    long date = mmsCursor.getLong(mmsCursor.getColumnIndex("date")) * 1000;
                    String tel = getMMSAddress(id);
                    String msg = parseMessage(id + "");

                    SMS sms = new SMS(id,msg, tel, tel, Utils.getStringDateAsYYYYMMddHHmmss(convertDateLongToCalendar(date)), Constants.SMSType.SMS.ordinal());

                    return sms;
                }

            }
        } catch (SQLiteException e) {
        } finally {
            if(mmsCursor!=null)mmsCursor.close();
        }

        return null;
    }


    public String getMMSAddress(int id) {

        String addrSelection = "msg_id=" + id;
        Cursor cursor = null;
        String address = "";
        String uriStr = "content://mms/" + id + "/addr";
        Uri uriAddress = Uri.parse(uriStr);
        String[] columns = {"address"};
        try {
            cursor = mContext.getContentResolver().query(uriAddress, columns,
                    addrSelection, null, null);

            if (cursor != null && cursor.moveToFirst()) {
                do {
                    String val = cursor.getString(cursor.getColumnIndex("address"));
                    if (val != null) {
                        address = val.replace("-", "");
                        break;
                    }
                } while (cursor.moveToNext());
            }
        } catch (SQLiteException e) {
        } catch (SecurityException e) {
            e.printStackTrace();
        } finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return address;
    }

    public String parseMessage(String id) {
        Cursor cursor = null;
        String msg = null;
        Uri uri = Uri.parse("content://mms/part");
        try {
            cursor = mContext.getContentResolver().query(uri, null,
                    null, null, null);

            if (cursor != null) {
                if (cursor.moveToFirst()) {
                    while (!cursor.isAfterLast()) {
                        String mid = cursor.getString(cursor.getColumnIndex("mid"));
                        if (id.equals(mid)) {
                            String partId = cursor.getString(cursor.getColumnIndex("_id"));
                            String type = cursor.getString(cursor.getColumnIndex("ct"));

                            if ("text/plain".equals(type)) {
                                String data = cursor.getString(cursor.getColumnIndex("_data"));


                                if (data != null && !TextUtils.isEmpty(data)) {
                                    // implementation of this method below
                                    msg = getMmsText(partId);
                                } else {
                                    msg = cursor.getString(cursor.getColumnIndex("text"));
                                }
                            }
                        }
                        cursor.moveToNext();
                    }
                }
            }

        } catch (Exception e) {
        } finally {
            if (cursor != null) cursor.close();
        }

        return msg;
    }

    private String getMmsText(String id) {
        Uri partURI = Uri.parse("content://mms/part/" + id);
        InputStream is = null;
        StringBuilder sb = new StringBuilder();
        try {
            is = mContext.getContentResolver().openInputStream(partURI);
            if (is != null) {
                InputStreamReader isr = new InputStreamReader(is, "UTF-8");
                BufferedReader reader = new BufferedReader(isr);
                String temp = reader.readLine();
                while (temp != null) {
                    sb.append(temp);
                    temp = reader.readLine();
                }

                isr.close();
                reader.close();
            }


        } catch (IOException e) {

        } finally {
            if (is != null) {
                try {
                    is.close();
                } catch (IOException e) {
                }
            }
        }
        return sb.toString();
    }


    private Calendar convertDateLongToCalendar(long date) {
        Calendar cal = Calendar.getInstance();
        if (date != 0)
            cal.setTimeInMillis(date);
        return cal;
    }

}
