package com.tenqube.visual_third.parser.catcher;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;

import tenqube.parser.model.SMS;

import static com.tenqube.visual_third.util.Utils.isSDKDisabled;


public class MMSCatcher extends BroadcastReceiver {

    public static final String MMS_ACTION = "android.provider.Telephony.WAP_PUSH_RECEIVED";

    public MMSHelper mmsHelper;

    public MMSCatcher() {
        super();
    }

    @Override
    public void onReceive(final Context context, final Intent intent) {

        if(isSDKDisabled(context))
            return;

        try {
            Runnable runn = new Runnable() {
                @Override
                public void run() {
                    if(intent != null) {
                        String action = intent.getAction();
                        if (action != null) {
                            if (MMS_ACTION.equals(action)) {
                                if(mmsHelper == null) mmsHelper = new MMSHelper(context);
                                sendIntentService(context, mmsHelper.getMMS());
                            }
                        }
                    }
                }
            };
            Handler handler = new Handler();
            handler.postDelayed(runn, 4000); // 시간이 너무 짧으면 못 가져오는게 있더라
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void sendIntentService(Context context, SMS sms) {
        Intent startIntent = new Intent(context, SmsMmsService.class);
        startIntent.putExtra(SmsMmsService.ARG_SMS, sms);
        context.startService(startIntent);
    }
}
