/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.ui;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.support.v4.app.FragmentManager;
import android.support.v4.content.LocalBroadcastManager;
import android.support.v4.widget.SwipeRefreshLayout;
import android.support.v7.app.AppCompatActivity;
import android.text.TextUtils;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ProgressBar;
import com.tenqube.visual_third.R;
import com.tenqube.visual_third.VisualServiceImpl;
import com.tenqube.visual_third.analysis.AnalysisServiceImpl;
import com.tenqube.visual_third.api.VisualApi;
import com.tenqube.visual_third.exception.AuthException;
import com.tenqube.visual_third.manager.AnswerManager;
import com.tenqube.visual_third.manager.PrefManager;
import com.tenqube.visual_third.manager.VisualAlarmManager;
import com.tenqube.visual_third.model.js.DateRequest;
import com.tenqube.visual_third.model.js.LogRequest;
import com.tenqube.visual_third.model.js.TimeRequest;
import com.tenqube.visual_third.repository.VisualRepository;
import com.tenqube.visual_third.ui.BottomDialog;
import com.tenqube.visual_third.ui.DatePickerFragment;
import com.tenqube.visual_third.ui.NotiCatchDialogFragment;
import com.tenqube.visual_third.ui.TimePickerFragment;
import com.tenqube.visual_third.util.FontUtil;
import com.tenqube.visual_third.util.Utils;
import com.tenqube.visual_third.util.WebViewHelper;
import com.tenqube.visual_third.web.ErrorImpl;
import com.tenqube.visual_third.web.LogImpl;
import com.tenqube.visual_third.web.RepoImpl;
import com.tenqube.visual_third.web.SystemImpl;
import com.tenqube.visual_third.web.UiImpl;
import com.tenqube.visual_third.web.ViewContractor;
import com.tenqube.visual_third.web.VisualInterface;
import org.json.JSONException;
import org.json.JSONObject;

public class VisualWebActivity
extends AppCompatActivity
implements TimePickerFragment.Callback,
DatePickerFragment.Callback,
ViewContractor {
    public static final String TAG = VisualServiceImpl.class.getSimpleName();
    public static final String ACTION_INITIALIZE = "ACTION_INITIALIZE";
    public static final String ARG_PATH = "PATH";
    public static final int POPUP_CODE = 1000;
    private PrefManager prefManager;
    private VisualApi api;
    private boolean isPageLoaded;
    private String mFailingUrl;
    private LocalBroadCastReceiver receiver = new LocalBroadCastReceiver();
    private String path;
    private WebView webview;
    private VisualInterface.Repo repoInterface;
    private VisualInterface.UI uiInterface;
    private VisualInterface.System systemInterface;
    private VisualInterface.Error errorInterface;
    private VisualInterface.Log logInterface;
    private SwipeRefreshLayout swipeRefreshLayout;
    private ProgressBar progressBar;

    public static void startActivity(Context context, String path) throws AuthException {
        if (TextUtils.isEmpty((CharSequence)PrefManager.getInstance(context).loadStringValue("TENQUBE_UID", ""))) {
            throw new AuthException("Need to sign up");
        }
        Intent intent = new Intent(context, VisualWebActivity.class);
        intent.putExtra(ARG_PATH, path);
        context.startActivity(intent);
    }

    @SuppressLint(value={"JavascriptInterface", "AddJavascriptInterface", "SetJavaScriptEnabled"})
    protected void onCreate(Bundle savedInstanceState) {
        Utils.changeStatusColor((Activity)this, 17170443);
        super.onCreate(savedInstanceState);
        try {
            if (Utils.isSDKDisabled(this.getApplicationContext())) {
                throw new Exception("SDK disabled");
            }
            AnswerManager.initFabric((Context)this);
            AnswerManager.onKeyMetric(new LogRequest("VisualWebActivity"));
            this.api = VisualApi.getInstance(this.getApplicationContext());
            this.prefManager = PrefManager.getInstance(this.getApplicationContext());
            this.path = this.getIntent().getStringExtra(ARG_PATH);
            this.setContentView(R.layout.activity_visual_web);
            FontUtil.setAllTextView(this.findViewById(R.id.container));
            this.progressBar = (ProgressBar)this.findViewById(R.id.progress_bar);
            this.progressBar.setVisibility(8);
            this.swipeRefreshLayout = (SwipeRefreshLayout)this.findViewById(R.id.swipe_refresh_layout);
            this.swipeRefreshLayout.setEnabled(false);
            this.swipeRefreshLayout.setColorSchemeResources(new int[]{R.color.colorPopupRed, R.color.colorPopupRed, R.color.colorPopupRed});
            this.swipeRefreshLayout.setOnRefreshListener(new SwipeRefreshLayout.OnRefreshListener(){

                public void onRefresh() {
                    VisualWebActivity.this.swipeRefreshLayout.setRefreshing(false);
                    VisualWebActivity.this.webview.reload();
                }
            });
            this.webview = (WebView)this.findViewById(R.id.visual_web_view);
            this.webview.setBackgroundColor(0);
            this.webview.getSettings().setTextZoom(100);
            this.errorInterface = new ErrorImpl((Context)this, this, this.webview);
            this.logInterface = new LogImpl((Context)this, this, this.webview, this.errorInterface);
            this.repoInterface = new RepoImpl((Context)this, this, this.webview, this.errorInterface, VisualRepository.getInstance((Context)this), this.api, new AnalysisServiceImpl((Context)this, this.prefManager.loadStringValue("TENQUBE_QUALIFIER", "dev")), VisualAlarmManager.getInstance((Context)this));
            this.uiInterface = new UiImpl((Context)this, this, this.webview, this.errorInterface, new BottomDialog((Activity)this));
            this.systemInterface = new SystemImpl((Context)this, this, this.webview, this.errorInterface);
            this.webview.addJavascriptInterface((Object)this.errorInterface, "visualError");
            this.webview.addJavascriptInterface((Object)this.repoInterface, "visualRepo");
            this.webview.addJavascriptInterface((Object)this.uiInterface, "visualUI");
            this.webview.addJavascriptInterface((Object)this.systemInterface, "visualSystem");
            this.webview.addJavascriptInterface((Object)this.logInterface, "visualLog");
            WebViewHelper.settings(this.webview);
            this.webview.setWebViewClient(new WebViewClient(){

                public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
                    VisualWebActivity.this.mFailingUrl = failingUrl;
                    if (VisualWebActivity.this.progressBar != null) {
                        VisualWebActivity.this.progressBar.setVisibility(8);
                    }
                    VisualWebActivity.this.loadErrorUrl();
                }

                public void onPageStarted(WebView view, String url, Bitmap favicon) {
                    super.onPageStarted(view, url, favicon);
                    if (VisualWebActivity.this.progressBar != null) {
                        VisualWebActivity.this.progressBar.setVisibility(0);
                    }
                }

                public void onPageCommitVisible(WebView view, String url) {
                    super.onPageCommitVisible(view, url);
                    if (VisualWebActivity.this.progressBar != null) {
                        VisualWebActivity.this.progressBar.setVisibility(8);
                    }
                }

                public void onPageFinished(WebView view, String url) {
                    super.onPageFinished(view, url);
                    if (VisualWebActivity.this.progressBar != null) {
                        VisualWebActivity.this.progressBar.setVisibility(8);
                    }
                }
            });
            if (this.prefManager.loadStringValue("TENQUBE_QUALIFIER", "dev").equals("dev")) {
                this.webview.getSettings().setCacheMode(2);
            }
            this.loadUrl();
        }
        catch (Exception e) {
            this.finish();
        }
    }

    private void loadUrl() {
        if (this.webview != null) {
            this.isPageLoaded = false;
            if (TextUtils.isEmpty((CharSequence)this.path)) {
                this.path = "";
            }
            String url = WebViewHelper.getBaseUrl(this.prefManager) + this.path;
            this.webview.loadUrl(url);
        }
    }

    private void loadErrorUrl() {
        this.isPageLoaded = false;
        if (this.swipeRefreshLayout != null) {
            this.swipeRefreshLayout.setEnabled(false);
        }
        if (this.webview != null) {
            this.webview.loadUrl("file:///android_asset/index.html");
        }
    }

    @Override
    public void onCalendar(String date, String callback) {
        this.uiInterface.onCalendar(date, callback);
    }

    @Override
    public void onPageLoaded() {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                VisualWebActivity.this.isPageLoaded = true;
            }
        });
    }

    @Override
    public void setRefreshEnabled(final boolean enabled) {
        try {
            this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    VisualWebActivity.this.swipeRefreshLayout.setEnabled(enabled);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void showDatePicker(DateRequest dateRequest) {
        DatePickerFragment newFragment = DatePickerFragment.newInstance(dateRequest);
        newFragment.show(this.getSupportFragmentManager(), "datePicker");
    }

    @Override
    public void showTimePicker(TimeRequest timeRequest) {
        TimePickerFragment newFragment = TimePickerFragment.newInstance(timeRequest);
        newFragment.show(this.getSupportFragmentManager(), "timePicker");
    }

    @Override
    public void onFinish(String path) {
        Intent intent = this.getIntent();
        this.setResult(TextUtils.isEmpty((CharSequence)path) || "false".equals(path) ? 0 : -1, intent);
        this.finish();
    }

    @Override
    public void startPopup(String path) {
        Intent intent = new Intent(this.getApplicationContext(), VisualWebActivity.class);
        intent.putExtra(ARG_PATH, path);
        this.startActivityForResult(intent, 1000);
    }

    @Override
    public void showNotiCatch() {
        NotiCatchDialogFragment notiCatchDialogFragment = NotiCatchDialogFragment.newInstance();
        if (!notiCatchDialogFragment.isAdded()) {
            FragmentManager fragmentManager = this.getSupportFragmentManager();
            notiCatchDialogFragment.show(fragmentManager, NotiCatchDialogFragment.TAG);
        }
    }

    @Override
    public void goNotiSettings() throws ActivityNotFoundException {
        Intent intent = new Intent("android.settings.ACTION_NOTIFICATION_LISTENER_SETTINGS");
        this.startActivityForResult(intent, 10);
    }

    @Override
    public void reload() {
        if (this.webview != null) {
            this.webview.post(new Runnable(){

                @Override
                public void run() {
                    VisualWebActivity.this.webview.reload();
                }
            });
        }
    }

    @Override
    public void retry() {
        if (this.webview != null) {
            this.webview.post(new Runnable(){

                @Override
                public void run() {
                    VisualWebActivity.this.webview.loadUrl(VisualWebActivity.this.mFailingUrl);
                }
            });
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        switch (requestCode) {
            case 10: {
                boolean isEnabled = Utils.isNotiEnabled(this.getApplicationContext());
                JSONObject jsonObject = new JSONObject();
                try {
                    jsonObject.put("isNotiEnabled", isEnabled);
                    String json = jsonObject.toString();
                    if (this.systemInterface == null) break;
                    this.systemInterface.onNotiCallback(json);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                break;
            }
            case 1000: {
                this.setResult(resultCode);
                this.finish();
            }
        }
    }

    public void onBackPressed() {
        try {
            if (this.isPageLoaded && this.uiInterface != null) {
                this.uiInterface.onFinish();
            } else {
                super.onBackPressed();
            }
        }
        catch (Exception e) {
            super.onBackPressed();
        }
    }

    protected void onResume() {
        super.onResume();
        this.overridePendingTransition(R.anim.slide_in_up, R.anim.stay);
        IntentFilter filter = new IntentFilter();
        filter.addAction(ACTION_INITIALIZE);
        LocalBroadcastManager.getInstance((Context)this.getApplicationContext()).registerReceiver((BroadcastReceiver)this.receiver, filter);
    }

    protected void onPause() {
        super.onPause();
        this.overridePendingTransition(R.anim.stay, R.anim.slide_out_down);
        LocalBroadcastManager.getInstance((Context)this.getApplicationContext()).unregisterReceiver((BroadcastReceiver)this.receiver);
    }

    public class LocalBroadCastReceiver
    extends BroadcastReceiver {
        public void onReceive(Context context, Intent intent) {
            VisualWebActivity.this.finish();
        }
    }
}

