/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.ui;

import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.graphics.Typeface;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.support.v4.app.DialogFragment;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;
import com.tenqube.visual_third.R;
import com.tenqube.visual_third.util.FontUtil;

public class NotificationDialogFragment
extends DialogFragment {
    public static final String TAG = NotificationDialogFragment.class.getSimpleName();
    Callback callback;

    public static NotificationDialogFragment newInstance() {
        return new NotificationDialogFragment();
    }

    public void setCallback(Callback callback) {
        this.callback = callback;
    }

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        try {
            AlertDialog.Builder builder = new AlertDialog.Builder(this.getContext());
            View view = this.getActivity().getLayoutInflater().inflate(R.layout.dialog_notification, null);
            FontUtil.setAllTextView(view);
            Typeface bold = FontUtil.getFont((Context)this.getActivity(), "Tenqube-NotoSansKR-Bold.otf");
            TextView title = (TextView)view.findViewById(R.id.title);
            title.setTypeface(bold);
            Button okButton = (Button)view.findViewById(R.id.ok);
            okButton.setTypeface(bold);
            okButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    NotificationDialogFragment.this.dismissAllowingStateLoss();
                    if (NotificationDialogFragment.this.callback != null) {
                        NotificationDialogFragment.this.callback.onOkButtonClicked();
                    }
                }
            });
            Button cancelButton = (Button)view.findViewById(R.id.cancel);
            cancelButton.setTypeface(bold);
            cancelButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    NotificationDialogFragment.this.dismissAllowingStateLoss();
                    if (NotificationDialogFragment.this.callback != null) {
                        NotificationDialogFragment.this.callback.onCancelButtonClicked();
                    }
                }
            });
            builder.setView(view);
            AlertDialog dialog = builder.create();
            dialog.requestWindowFeature(1);
            dialog.setCanceledOnTouchOutside(true);
            if (dialog.getWindow() != null) {
                dialog.getWindow().requestFeature(1);
            }
            return dialog;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.dismissAllowingStateLoss();
            return null;
        }
    }

    public void onStart() {
        super.onStart();
        Dialog dialog = this.getDialog();
        if (dialog != null && dialog.getWindow() != null) {
            dialog.getWindow().setLayout(-1, -2);
            dialog.getWindow().setBackgroundDrawable((Drawable)new ColorDrawable(0));
        }
    }

    static interface Callback {
        public void onOkButtonClicked();

        public void onCancelButtonClicked();
    }
}

