package com.tenqube.visual_third.ui;

import android.app.Dialog;
import android.graphics.Color;
import android.graphics.Typeface;
import android.graphics.drawable.ColorDrawable;
import android.os.Bundle;
import android.support.v4.app.DialogFragment;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.Button;
import android.widget.TextView;

import com.tenqube.visual_third.R;
import com.tenqube.visual_third.util.FontUtil;

import static com.tenqube.visual_third.util.FontUtil.setAllTextView;


public class NotificationDialogFragment extends DialogFragment {

    public static final String TAG = NotificationDialogFragment.class.getSimpleName();


    public NotificationDialogFragment() {
        super();
    }

    Callback callback;

    public static NotificationDialogFragment newInstance(){
        return new NotificationDialogFragment();
    }

    public void setCallback(Callback callback) {
        this.callback = callback;
    }

    @Override
    public Dialog onCreateDialog(Bundle savedInstanceState) {

        try {

            android.app.AlertDialog.Builder builder = new android.app.AlertDialog.Builder(getContext());
            View view = getActivity().getLayoutInflater().inflate(R.layout.dialog_notification,null);
            setAllTextView(view);

            Typeface bold = FontUtil.getFont(getActivity(), FontUtil.BOLD);
            TextView title = view.findViewById(R.id.title);
            title.setTypeface(bold);

            Button okButton = view.findViewById(R.id.ok);
            okButton.setTypeface(bold);


            okButton.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    dismissAllowingStateLoss();
                    if(callback != null) {
                        callback.onOkButtonClicked();
                    }
                }
            });

            Button cancelButton = view.findViewById(R.id.cancel);
            cancelButton.setTypeface(bold);

            cancelButton.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    dismissAllowingStateLoss();
                    if(callback != null) {
                        callback.onCancelButtonClicked();
                    }
                }
            });

            builder.setView(view);
            Dialog dialog = builder.create();
            dialog.requestWindowFeature(Window.FEATURE_NO_TITLE);
//        dialog.getWindow().setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));
            dialog.setCanceledOnTouchOutside(true);
            if(dialog.getWindow() != null) dialog.getWindow().requestFeature(Window.FEATURE_NO_TITLE);
            return dialog;
        } catch (Exception e) {
            e.printStackTrace();
            dismissAllowingStateLoss();
        }

        return null;

    }

    @Override
    public void onStart() {
        super.onStart();
        Dialog dialog = getDialog();
        if (dialog != null && dialog.getWindow() != null) {
            dialog.getWindow().setLayout(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT);
            dialog.getWindow().setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));
        }
    }



    interface Callback {

        void onOkButtonClicked();

        void onCancelButtonClicked();
    }

}
