/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.db;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;

public class Db {
    private final SQLiteDatabase wdb;
    private final SQLiteDatabase db;

    public Db(SQLiteDatabase wdb, SQLiteDatabase db) {
        this.wdb = wdb;
        this.db = db;
    }

    public SQLiteDatabase getDb() {
        return this.db;
    }

    public SQLiteDatabase getWritableDb() {
        return this.wdb;
    }

    public long insert(String tableName, ContentValues values) {
        try {
            return this.wdb.insert(tableName, null, values);
        }
        catch (SQLException e) {
            return 0L;
        }
    }

    public long insertOnIgnore(String tableName, ContentValues values) {
        try {
            return this.wdb.insertWithOnConflict(tableName, null, values, 4);
        }
        catch (SQLException e) {
            return 0L;
        }
    }

    public long insertOnReplace(String tableName, ContentValues values) {
        try {
            return this.wdb.insertWithOnConflict(tableName, null, values, 5);
        }
        catch (SQLException e) {
            return 0L;
        }
    }

    public long update(String tableName, ContentValues values, String selection, String[] selectionArgs) {
        try {
            return this.wdb.update(tableName, values, selection, selectionArgs);
        }
        catch (SQLException e) {
            return 0L;
        }
    }

    public long delete(String tableName, String selection, String[] selectionArgs) {
        try {
            return this.wdb.delete(tableName, selection, selectionArgs);
        }
        catch (SQLException e) {
            return 0L;
        }
    }

    public Cursor runQuery(String query) {
        Cursor rows = this.db.rawQuery(query, null);
        if (rows == null) {
            return null;
        }
        try {
            int rowCount = rows.getCount();
            if (rowCount == 0 || !rows.moveToLast()) {
                rows.close();
                return null;
            }
        }
        catch (RuntimeException ex) {
            rows.close();
            return null;
        }
        return rows;
    }
}

