package com.tenqube.visual_third.util;

import android.content.Context;
import android.graphics.Typeface;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

public class FontUtil {

    public static final String REGULAR = "Tenqube-NotoSans-Regular.otf";

    public static void setAllTextView(View view) {

        ViewGroup parent;
        if(view instanceof ViewGroup) {
            parent = (ViewGroup)view;
            for (int i = parent.getChildCount() - 1; i >= 0; i--) {
                final View child = parent.getChildAt(i);
                if (child instanceof ViewGroup) {
                    setAllTextView((ViewGroup) child);
                } else if (child instanceof TextView) {
                    Typeface typeface = getFont(parent.getContext());
                    if(typeface != null) {
                        ((TextView) child).setTypeface(typeface);
                    } else {
                        break;
                    }
                }
            }
        }
    }

    public static Typeface getFont(Context context) {
        try {
            return Typeface.createFromAsset(context.getAssets(), REGULAR);

        } catch (Exception e) {
            return null;
        }
    }

    public static void setFont(Context context, TextView textView, String font) {
        try {
            Typeface tf = Typeface.createFromAsset(context.getAssets(),font);
            textView.setTypeface(tf);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
