/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.support.v4.content.LocalBroadcastManager;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CompoundButton;
import android.widget.LinearLayout;
import android.widget.Switch;
import com.tenqube.visual_third.Callback;
import com.tenqube.visual_third.R;
import com.tenqube.visual_third.VisualService;
import com.tenqube.visual_third.VisualServiceImpl;
import com.tenqube.visual_third.exception.AuthException;
import com.tenqube.visual_third.exception.ParameterException;
import com.tenqube.visual_third.model.parser.PopupData;
import com.tenqube.visual_third.ui.OnResultListener;
import com.tenqube.visual_third.ui.VisualWebActivity;

public class MainActivity
extends Activity {
    private VisualService visualService;
    private LinearLayout container;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_main);
        try {
            this.visualService = new VisualServiceImpl((Context)this, "", "dev", "com.tenqube.visual_third");
            this.visualService.setLogger(true);
            this.visualService.settingNotification(R.drawable.ic_deposit_loan, "1234", 0);
            Switch popup = (Switch)this.findViewById(R.id.popup);
            popup.setChecked(this.visualService.isActiveTranPopup());
            popup.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

                public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                    MainActivity.this.visualService.setTranPopup(isChecked);
                }
            });
            Switch daily = (Switch)this.findViewById(R.id.daily);
            daily.setChecked(this.visualService.isActiveDailyNoti());
            daily.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

                public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                    MainActivity.this.visualService.setDailyNoti(isChecked);
                }
            });
            Switch weekly = (Switch)this.findViewById(R.id.weekly);
            weekly.setChecked(this.visualService.isActiveWeeklyNoti());
            weekly.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

                public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                    MainActivity.this.visualService.setWeeklyNoti(isChecked);
                }
            });
            Switch monthly = (Switch)this.findViewById(R.id.monthly);
            monthly.setChecked(this.visualService.isActiveMonthlyNoti());
            monthly.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

                public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                    MainActivity.this.visualService.setMonthlyNoti(isChecked);
                }
            });
            IntentFilter filter = new IntentFilter();
            filter.addAction("tenqube.intent.action.ACTION_TRAN_POPUP");
            LocalBroadcastManager.getInstance((Context)this.getApplicationContext()).registerReceiver((BroadcastReceiver)new TranReceiver(), filter);
            this.container = (LinearLayout)this.findViewById(R.id.adContainer);
            this.findViewById(R.id.ad).setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    MainActivity.this.visualService.signOut(new Callback(){

                        public void onDataLoaded(Object value) {
                        }
                    });
                }
            });
        }
        catch (ParameterException e) {
            e.printStackTrace();
        }
    }

    public void onWeb(View view) {
        try {
            this.visualService.startVisual(this, "1234", "", new OnResultListener(){

                @Override
                public void onResult(int signUpResult, String msg) {
                }
            });
        }
        catch (ParameterException e) {
            e.printStackTrace();
        }
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        switch (requestCode) {
            case 0: {
                if (grantResults.length > 0 && grantResults[0] == 0) {
                    try {
                        this.visualService.startVisual(this, "1234", "", new OnResultListener(){

                            @Override
                            public void onResult(int signUpResult, String msg) {
                            }
                        });
                    }
                    catch (ParameterException e) {
                        e.printStackTrace();
                    }
                }
                return;
            }
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
    }

    public class TranReceiver
    extends BroadcastReceiver {
        public void onReceive(Context context, Intent intent) {
            Bundle bundle;
            if ("tenqube.intent.action.ACTION_TRAN_POPUP".equals(intent.getAction()) && (bundle = intent.getBundleExtra("popup_data")) != null) {
                PopupData popupData = (PopupData)bundle.getSerializable("popup_data");
                try {
                    VisualWebActivity.startActivity(context, popupData);
                }
                catch (AuthException e) {
                    e.printStackTrace();
                }
                catch (ParameterException e) {
                    e.printStackTrace();
                }
                if (popupData != null) {
                    MainActivity.this.container.removeAllViews();
                    if (popupData.getAdView().getParent() != null) {
                        ((ViewGroup)popupData.getAdView().getParent()).removeView(popupData.getAdView());
                    }
                    MainActivity.this.container.addView(popupData.getAdView());
                }
            }
        }
    }
}

