package com.tenqube.visual_third.db.dao;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteException;
import android.text.TextUtils;

import com.tenqube.visual_third.db.Db;
import com.tenqube.visual_third.db.QueryGenerator;
import com.tenqube.visual_third.db.ReaderContract;
import com.tenqube.visual_third.entity.Card;

import java.util.ArrayList;
import java.util.List;

import tenqube.parser.constants.Constants;

import static com.tenqube.visual_third.db.QueryGenerator.AND;

public class CardDao {

    private final Db db;

    public CardDao(Db db) {
        this.db = db;
    }

    public ArrayList<Card> loadCards() {
        String query = QueryGenerator.card();
        ArrayList<Card> results = new ArrayList<>();
        Cursor c = null;

        try {
            c = db.runQuery(query);
            if(c != null) {
                if(c.moveToFirst()) {
                    while (!c.isAfterLast()) {
                        results.add(ReaderContract.CardTable.populateModel(c));
                        c.moveToNext();
                    }
                }
            }
        } catch (SQLiteException e) {

        } finally {
            if(c != null) {
                c.close();
            }
        }

        return results;
    }

    public int getCardId(String cardName, int cardType, int cardSubType) {
        String query = QueryGenerator.cardId();
        Cursor c = null;

        String[] values = new String[] {cardName, cardType + "", cardSubType + ""};
        try {
            c = db.runQuery(query, values);
            if(c != null) {
                if(c.moveToFirst()) {
                    return c.getInt(c.getColumnIndex(ReaderContract.CardTable.COLUMN_CARD_ID));
                }
            }
        } catch (SQLiteException e) {

        } finally {
            if(c != null) {
                c.close();
            }
        }

        return -1;
    }

    public int insert(String cardName, int cardType, int cardSubType) {

        try {
            ContentValues values = new ContentValues();
            values.put(ReaderContract.CardTable.COLUMN_CARD_NAME, cardName);
            values.put(ReaderContract.CardTable.COLUMN_CARD_TYPE, cardType);
            values.put(ReaderContract.CardTable.COLUMN_CARD_SUB_TYPE, cardSubType);

            values.put(ReaderContract.CardTable.COLUMN_CHANGE_NAME, cardName);
            values.put(ReaderContract.CardTable.COLUMN_CHANGE_TYPE, cardType);
            values.put(ReaderContract.CardTable.COLUMN_CHANGE_SUB_TYPE, cardSubType);

            return (int) db.insert(ReaderContract.CardTable.TABLE_NAME, values);
        } catch (Exception e) {

        }

        return 0;

    }

    public void insertCash() {
        try {

            db.insert(ReaderContract.CardTable.TABLE_NAME, ReaderContract.CardTable.populateData());
        } catch (Exception e) {

        }
    }

    public void deleteAll() {
        try {
            db.delete(ReaderContract.CardTable.TABLE_NAME, null, null);
        } catch (Exception e) {

        }


    }

    public void deleteCardsByIds(List<Integer> ids) {
        try {
            db.delete(ReaderContract.CardTable.TABLE_NAME, ReaderContract.CardTable.COLUMN_CARD_ID + " IN (" + TextUtils.join(",", ids) + ")", null);
        } catch (Exception e) {

        }
    }

    public void deleteCardsByNotInIds(List<Integer> ids) {
        try {
            db.delete(ReaderContract.CardTable.TABLE_NAME, ReaderContract.CardTable.COLUMN_CARD_ID + " NOT IN (" + TextUtils.join(",", ids) + ") " + AND + ReaderContract.CardTable.COLUMN_CARD_TYPE  + " != " + Constants.CardType.CASH.ordinal(), null);
        } catch (Exception e) {

        }
    }

    public void deleteCardsExceptCache() {
        try {
            db.delete(ReaderContract.CardTable.TABLE_NAME, ReaderContract.CardTable.COLUMN_CARD_TYPE  + " != " + Constants.CardType.CASH.ordinal(), null);
        } catch (Exception e) {

        }
    }

}
