package com.tenqube.visual_third.entity;

import java.io.Serializable;

public class VisualNotification implements Serializable {

    //        id	name	title	content	ticker	alarm_type	day_of_week	hour	day	version	enable	created_at

    private final int id;

    private final String name;

    private final String title;

    private final String content;

    private final String ticker;

    private final int alarmType;

    private final int dayOfWeek;

    private final int day;

    private final  int hour;

    private final boolean enable;

    private String createdAt;

    public VisualNotification(int id, String name, String title, String content, String ticker, int alarmType, int dayOfWeek, int day, int hour, boolean enable) {
        this.id = id;
        this.name = name;
        this.title = title;
        this.content = content;
        this.ticker = ticker;
        this.alarmType = alarmType;
        this.dayOfWeek = dayOfWeek;
        this.day = day;
        this.hour = hour;
        this.enable = enable;
    }

    public VisualNotification(int id, String name, String title, String content, String ticker, int alarmType, int dayOfWeek, int hour, int day, boolean enable, String createdAt) {
        this.id = id;
        this.name = name;
        this.title = title;
        this.content = content;
        this.ticker = ticker;
        this.alarmType = alarmType;
        this.dayOfWeek = dayOfWeek;
        this.hour = hour;
        this.day = day;
        this.enable = enable;
        this.createdAt = createdAt;
    }

    public int getId() {
        return id;
    }

    public String getName() {
        return name;
    }

    public String getTitle() {
        return title;
    }

    public String getContent() {
        return content;
    }

    public String getTicker() {
        return ticker;
    }

    public int getAlarmType() {
        return alarmType;
    }

    public int getDayOfWeek() {
        return dayOfWeek;
    }

    public int getDay() {
        return day;
    }

    public int getHour() {
        return hour;
    }

    public boolean isEnable() {
        return enable;
    }

    public String getCreatedAt() {
        return createdAt;
    }

    public String insertValues() {

        int enableValue = (enable ? 1 : 0);
        return "(" +
                id + "," +
                "'" + name + "'," +
                "'" + title + "'," +
                "'" + content + "'," +
                "'" + ticker + "'," +
                "" + alarmType + "," +
                "" + dayOfWeek + "," +
                "" + hour + "," +
                "" + day + "," +
                "" + enableValue  + "," +
                "'" + createdAt + "')" ;
    }
}
