package com.tenqube.visual_third;

import android.support.annotation.NonNull;
import android.support.v7.app.AppCompatActivity;

import com.tenqube.visual_third.exception.ParameterException;

public interface VisualService {

    void startVisual(@NonNull final AppCompatActivity activity, final int containerId, final boolean isBackStack, @NonNull String uid) throws ParameterException, SecurityException;

    /**
     * 팝업 보여질지 여부를 확인 합니다.
     * @return 팝업 보여질 여부 (true : 보여짐 , false : 안보여짐)
     */
    boolean isActiveTranPopup();

    /**
     * 팝업 호출 여부
     * @param isActive 팝업 보여질 여부 (true : 보여짐 , false : 안보여짐)
     */
    void setTranPopup(boolean isActive);
    /**
     * 로그 확인을 위한 디버그 적용 함수
     * @param isDebug 디버그 여부
     */
    void setDebugMode(boolean isDebug);

    /**
     * SDK초기화 함수 개발 전용
     */
    void initSDK();

    /**
     * SDK 사용 여부 판단 플레그
     * @param enabled true : 동작 / false : 동작 안함.
     */
    void setEnabled(boolean enabled);

}
