/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.ui;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.widget.SwipeRefreshLayout;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import com.tenqube.visual_third.R;
import com.tenqube.visual_third.VisualServiceImpl;
import com.tenqube.visual_third.analysis.AnalysisServiceImpl;
import com.tenqube.visual_third.api.VisualApi;
import com.tenqube.visual_third.manager.AnswerManager;
import com.tenqube.visual_third.manager.PrefManager;
import com.tenqube.visual_third.manager.ResourceManager;
import com.tenqube.visual_third.manager.VisualAlarmManager;
import com.tenqube.visual_third.model.api.SearchCompanyRequest;
import com.tenqube.visual_third.model.api.SignUpRequest;
import com.tenqube.visual_third.model.api.SignUpResponse;
import com.tenqube.visual_third.model.js.DateRequest;
import com.tenqube.visual_third.model.js.LogRequest;
import com.tenqube.visual_third.model.js.TimeRequest;
import com.tenqube.visual_third.parser.loader.BulkLoader;
import com.tenqube.visual_third.repository.VisualRepository;
import com.tenqube.visual_third.ui.BottomDialog;
import com.tenqube.visual_third.ui.DatePickerFragment;
import com.tenqube.visual_third.ui.OnResultListener;
import com.tenqube.visual_third.ui.ProgressDialogFragment;
import com.tenqube.visual_third.ui.TimePickerFragment;
import com.tenqube.visual_third.ui.VisualWebActivity;
import com.tenqube.visual_third.util.Utils;
import com.tenqube.visual_third.util.WebViewHelper;
import com.tenqube.visual_third.web.ErrorImpl;
import com.tenqube.visual_third.web.LogImpl;
import com.tenqube.visual_third.web.RepoImpl;
import com.tenqube.visual_third.web.SystemImpl;
import com.tenqube.visual_third.web.UiImpl;
import com.tenqube.visual_third.web.ViewContractor;
import com.tenqube.visual_third.web.VisualInterface;
import java.util.Calendar;
import org.json.JSONException;
import org.json.JSONObject;
import tenqube.parser.core.ParserService;
import tenqube.parser.util.LogUtil;

public class VisualActivityFragment
extends Fragment
implements TimePickerFragment.Callback,
DatePickerFragment.Callback,
ViewContractor {
    public static final String TAG = VisualServiceImpl.class.getSimpleName();
    public static final String ARG_UID = "UID";
    public static final String ARG_PATH = "PATH";
    public static final int FINISH = 10;
    public static final int PROGRESS = 11;
    public static final int SHOW_PROGRESS_BAR = 12;
    public static final int ERROR = 13;
    public static final int NOTIFICATION_REQUEST_CODE = 10;
    private VisualRepository repository;
    private BulkLoader bulkLoader;
    private ResourceManager resourceManager;
    private PrefManager prefManager;
    private VisualAlarmManager alarmManager;
    private VisualApi api;
    private String mFailingUrl;
    private ProgressDialogFragment progressDialog;
    private WebView webview;
    private VisualInterface.Repo repoInterface;
    private VisualInterface.UI uiInterface;
    private VisualInterface.System systemInterface;
    private VisualInterface.Error errorInterface;
    private VisualInterface.Log logInterface;
    private SwipeRefreshLayout swipeRefreshLayout;
    private boolean isPageLoaded;
    private OnFragBackListener listener;
    private LinearLayout bulkContainer;
    private ProgressBar progressBar;
    private String uid;
    private String path;
    private Handler handler = new Handler(new Handler.Callback(){

        public boolean handleMessage(Message msg) {
            try {
                switch (msg.what) {
                    case 11: {
                        Bundle bundle;
                        if (VisualActivityFragment.this.progressDialog != null && VisualActivityFragment.this.progressDialog.isAdded() && (bundle = msg.getData()) != null) {
                            VisualActivityFragment.this.progressDialog.setProgressValue(bundle.getInt("now"), bundle.getInt("total"), bundle.getInt("percent"));
                        }
                        break;
                    }
                    case 12: {
                        try {
                            if (VisualActivityFragment.this.progressDialog == null) {
                                VisualActivityFragment.this.progressDialog = ProgressDialogFragment.newInstance((Context)VisualActivityFragment.this.getActivity());
                                VisualActivityFragment.this.progressDialog.setCancelable(false);
                            }
                            if (!VisualActivityFragment.this.progressDialog.isAdded()) {
                                FragmentManager fragmentManager = VisualActivityFragment.this.getActivity().getSupportFragmentManager();
                                VisualActivityFragment.this.progressDialog.show(fragmentManager, ProgressDialogFragment.TAG);
                            }
                        }
                        catch (Exception e) {
                            VisualActivityFragment.this.progressDialog = null;
                        }
                        break;
                    }
                    default: {
                        VisualActivityFragment.this.onBulkFinished();
                    }
                }
            }
            catch (Exception e) {
                VisualActivityFragment.this.onBulkFinished();
            }
            return false;
        }
    });

    public static VisualActivityFragment newInstance(String uid, String path) {
        VisualActivityFragment fragment = new VisualActivityFragment();
        Bundle bundle = new Bundle();
        bundle.putString(ARG_UID, uid);
        bundle.putString(ARG_PATH, path);
        fragment.setArguments(bundle);
        return fragment;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.getArguments() != null) {
            this.uid = this.getArguments().getString(ARG_UID, "");
            this.path = this.getArguments().getString(ARG_PATH, "");
        }
        this.api = VisualApi.getInstance((Context)this.getActivity());
        this.prefManager = PrefManager.getInstance((Context)this.getActivity());
        this.resourceManager = ResourceManager.getInstance(this.api, this.prefManager);
        this.repository = VisualRepository.getInstance((Context)this.getActivity());
        this.alarmManager = VisualAlarmManager.getInstance((Context)this.getActivity());
        AnswerManager.initFabric((Context)this.getActivity());
        AnswerManager.onKeyMetric(new LogRequest("VisualActivityFragment"));
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_visual_web, container, false);
    }

    @SuppressLint(value={"AddJavascriptInterface"})
    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        try {
            this.progressBar = (ProgressBar)view.findViewById(R.id.progress_bar);
            this.swipeRefreshLayout = (SwipeRefreshLayout)view.findViewById(R.id.swipe_refresh_layout);
            this.swipeRefreshLayout.setEnabled(false);
            this.swipeRefreshLayout.setColorSchemeResources(new int[]{R.color.colorPopupRed, R.color.colorPopupRed, R.color.colorPopupRed});
            this.swipeRefreshLayout.setOnRefreshListener(new SwipeRefreshLayout.OnRefreshListener(){

                public void onRefresh() {
                    VisualActivityFragment.this.swipeRefreshLayout.setRefreshing(false);
                    VisualActivityFragment.this.webview.reload();
                }
            });
            this.webview = (WebView)view.findViewById(R.id.visual_web_view);
            this.webview.getSettings().setTextZoom(100);
            this.errorInterface = new ErrorImpl((Context)this.getActivity(), this, this.webview);
            this.logInterface = new LogImpl((Context)this.getActivity(), this, this.webview, this.errorInterface);
            this.repoInterface = new RepoImpl((Context)this.getActivity(), this, this.webview, this.errorInterface, VisualRepository.getInstance((Context)this.getActivity()), this.api, new AnalysisServiceImpl((Context)this.getActivity()), this.alarmManager);
            this.uiInterface = new UiImpl((Context)this.getActivity(), this, this.webview, this.errorInterface, new BottomDialog((Activity)this.getActivity()));
            this.systemInterface = new SystemImpl((Context)this.getActivity(), this, this.webview, this.errorInterface);
            this.webview.addJavascriptInterface((Object)this.errorInterface, "visualError");
            this.webview.addJavascriptInterface((Object)this.repoInterface, "visualRepo");
            this.webview.addJavascriptInterface((Object)this.uiInterface, "visualUI");
            this.webview.addJavascriptInterface((Object)this.systemInterface, "visualSystem");
            this.webview.addJavascriptInterface((Object)this.logInterface, "visualLog");
            WebViewHelper.settings(this.webview);
            this.webview.setWebViewClient(new WebViewClient(){

                public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
                    VisualActivityFragment.this.mFailingUrl = failingUrl;
                    VisualActivityFragment.this.progressBar.setVisibility(8);
                    VisualActivityFragment.this.loadErrorUrl();
                }

                public void onPageStarted(WebView view, String url, Bitmap favicon) {
                    super.onPageStarted(view, url, favicon);
                    VisualActivityFragment.this.progressBar.setVisibility(0);
                }

                public void onPageCommitVisible(WebView view, String url) {
                    super.onPageCommitVisible(view, url);
                    VisualActivityFragment.this.progressBar.setVisibility(8);
                }
            });
            if (this.prefManager.loadStringValue("TENQUBE_QUALIFIER", "dev").equals("dev")) {
                this.webview.getSettings().setCacheMode(2);
            }
            this.bulkContainer = (LinearLayout)view.findViewById(R.id.start_bulk);
            if (!this.prefManager.isEnabled("TENQUBE_BULK_EXECUTED", false)) {
                this.bulkContainer.setVisibility(0);
                this.webview.loadUrl(String.format("http://%1$s.richnco-view.tenqube.kr/intro/", this.prefManager.loadStringValue("TENQUBE_QUALIFIER", "dev")));
                this.bulkContainer.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        VisualActivityFragment.this.signUp(VisualActivityFragment.this.uid, new OnResultListener(){

                            @Override
                            public void onResult(final int signUpResult, String msg) {
                                VisualActivityFragment.this.getActivity().runOnUiThread(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (signUpResult != 1) {
                                            VisualActivityFragment.this.startBulkParsing();
                                        } else {
                                            VisualActivityFragment.this.loadErrorUrl();
                                        }
                                    }
                                });
                            }
                        });
                    }
                });
            } else {
                this.bulkContainer.setVisibility(8);
                this.resourceManager.sync();
                this.loadUrl();
                this.syncSearchFailedTransactions();
                this.alarmManager.setAlarms();
                if (!TextUtils.isEmpty((CharSequence)this.path)) {
                    this.startPopup(this.path);
                }
            }
        }
        catch (Exception e) {
            this.getActivity().finish();
        }
    }

    private void loadUrl() {
        if (this.webview != null) {
            this.isPageLoaded = false;
            String url = WebViewHelper.getBaseUrl(this.prefManager);
            LogUtil.LOGI((String)TAG, (String)("loadUrl" + url), (boolean)ParserService.mIsDebug);
            this.webview.loadUrl(url);
        }
    }

    private void signUp(@NonNull String uid, final @NonNull OnResultListener onResultListener) {
        LogUtil.LOGI((String)TAG, (String)"\uac00\uc785", (boolean)ParserService.mIsDebug);
        final SignUpRequest signUpRequest = new SignUpRequest(uid);
        if (!TextUtils.isEmpty((CharSequence)this.prefManager.loadStringValue("TENQUBE_UID", ""))) {
            onResultListener.onResult(2, "already joined");
            return;
        }
        AnswerManager.onKeyMetric(new LogRequest("signUp"));
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    SignUpResponse response = VisualActivityFragment.this.api.signUp(signUpRequest);
                    if (response == null) {
                        onResultListener.onResult(1, "network error");
                    } else {
                        VisualActivityFragment.this.prefManager.saveStringValue("TENQUBE_SEARCH_URL", response.getResults().getSearch().getUrl());
                        VisualActivityFragment.this.prefManager.saveStringValue("TENQUBE_SEARCH_API_KEY", response.getResults().getSearch().getApiKey());
                        VisualActivityFragment.this.prefManager.saveStringValue("TENQUBE_UID", response.getResults().getAuthorization().getSdk());
                        VisualActivityFragment.this.prefManager.saveLongValue("TENQUBE_SIGN_UP_TIME", Calendar.getInstance().getTimeInMillis());
                        if (response.getResults().getWeb() != null) {
                            VisualActivityFragment.this.prefManager.saveStringValue("TENQUBE_WEB_URL", response.getResults().getWeb().getUrl());
                        }
                        onResultListener.onResult(0, "success");
                    }
                }
                catch (Exception e) {
                    onResultListener.onResult(1, e.toString());
                }
            }
        }).start();
    }

    private void loadErrorUrl() {
        this.isPageLoaded = false;
        if (this.swipeRefreshLayout != null) {
            this.swipeRefreshLayout.setEnabled(false);
        }
        if (this.webview != null) {
            this.webview.loadUrl("file:///android_asset/index.html");
        }
    }

    private void syncSearchFailedTransactions() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                SearchCompanyRequest request = VisualActivityFragment.this.repository.loadFailedSearchTransactions();
                if (request != null) {
                    VisualActivityFragment.this.api.searchCompany(request);
                }
                VisualActivityFragment.this.api.syncTransactions(null);
            }
        }).start();
    }

    private void onBulkFinished() {
        try {
            this.prefManager.saveBoolean("TENQUBE_BULK_EXECUTED", true);
            if (this.progressDialog != null && this.progressDialog.isAdded()) {
                this.progressDialog.dismissAllowingStateLoss();
            }
            this.bulkContainer.setVisibility(8);
            this.loadUrl();
            this.alarmManager.setAlarms();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void startBulkParsing() {
        LogUtil.LOGI((String)TAG, (String)"\ubc8c\ud06c \ud30c\uc2f1 \uc9c4\ud589", (boolean)ParserService.mIsDebug);
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    LogUtil.LOGI((String)TAG, (String)"startBulkParsing start", (boolean)ParserService.mIsDebug);
                    VisualActivityFragment.this.bulkLoader = new BulkLoader((Context)VisualActivityFragment.this.getActivity(), VisualActivityFragment.this.handler, new BulkLoader.OnSmsLoadFinished(){

                        @Override
                        public void onFinished(boolean isError) {
                            try {
                                if (VisualActivityFragment.this.handler != null) {
                                    VisualActivityFragment.this.handler.sendEmptyMessage(10);
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
                    LogUtil.LOGI((String)TAG, (String)"2. \ud504\ub85c\uadf8\ub808\uc2a4 \ub2e4\uc774\uc5bc\ub85c\uadf8 show", (boolean)ParserService.mIsDebug);
                    VisualActivityFragment.this.handler.sendEmptyMessage(12);
                    LogUtil.LOGI((String)TAG, (String)"3. \uc9c0\ub09c 6\uac1c\uc6d4 \ubb38\uc790 \ud30c\uc2f1 \uc2dc\uc791", (boolean)ParserService.mIsDebug);
                    VisualActivityFragment.this.bulkLoader.doParsing();
                }
                catch (Exception e) {
                    VisualActivityFragment.this.handler.sendEmptyMessage(13);
                }
            }
        }).start();
    }

    @Override
    public void onCalendar(String date, String callback) {
        this.uiInterface.onCalendar(date, callback);
    }

    @Override
    public void onPageLoaded() {
        this.getActivity().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                VisualActivityFragment.this.isPageLoaded = true;
            }
        });
    }

    @Override
    public void setRefreshEnabled(final boolean enabled) {
        this.swipeRefreshLayout.post(new Runnable(){

            @Override
            public void run() {
                VisualActivityFragment.this.swipeRefreshLayout.setEnabled(enabled);
            }
        });
    }

    @Override
    public void showDatePicker(DateRequest dateRequest) {
        DatePickerFragment newFragment = DatePickerFragment.newInstance(dateRequest);
        newFragment.show(this.getActivity().getSupportFragmentManager(), "datePicker");
    }

    @Override
    public void showTimePicker(TimeRequest timeRequest) {
        TimePickerFragment newFragment = TimePickerFragment.newInstance(timeRequest);
        newFragment.show(this.getActivity().getSupportFragmentManager(), "timePicker");
    }

    @Override
    public void onFinish(String path) {
        Intent intent = this.getActivity().getIntent();
        this.getActivity().setResult(TextUtils.isEmpty((CharSequence)path) || "false".equals(path) ? 0 : -1, intent);
        this.listener.onFragBackPressed();
    }

    @Override
    public void startPopup(String path) {
        Intent intent = new Intent((Context)this.getActivity(), VisualWebActivity.class);
        intent.putExtra(ARG_PATH, path);
        this.getActivity().startActivityForResult(intent, 1000);
    }

    @Override
    public void reload() {
        if (this.webview != null) {
            this.webview.post(new Runnable(){

                @Override
                public void run() {
                    VisualActivityFragment.this.webview.reload();
                }
            });
        }
    }

    @Override
    public void retry() {
        if (this.webview != null) {
            this.webview.post(new Runnable(){

                @Override
                public void run() {
                    VisualActivityFragment.this.webview.loadUrl(VisualActivityFragment.this.mFailingUrl);
                }
            });
        }
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        switch (requestCode) {
            case 10: {
                boolean isEnabled = Utils.isNotiEnabled((Context)this.getActivity());
                JSONObject jsonObject = new JSONObject();
                try {
                    jsonObject.put("isNotiEnabled", isEnabled);
                    String json = jsonObject.toString();
                    if (this.systemInterface == null) break;
                    this.systemInterface.onNotiCallback(json);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                break;
            }
            case 1000: {
                if (resultCode != -1) break;
                this.reload();
            }
        }
    }

    public void onBackPressed() {
        try {
            if (this.isPageLoaded && this.uiInterface != null) {
                this.uiInterface.onFinish();
            } else {
                this.onFragBackPressed();
            }
        }
        catch (Exception e) {
            this.onFragBackPressed();
        }
    }

    public void onFragBackPressed() {
        if (this.listener != null) {
            this.listener.onFragBackPressed();
        }
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        if (!(context instanceof OnFragBackListener)) {
            throw new RuntimeException(context.toString() + " must implement OnFragBackListener");
        }
        this.listener = (OnFragBackListener)context;
    }

    public void onResume() {
        super.onResume();
    }

    public void onDetach() {
        super.onDetach();
        this.listener = null;
    }

    public static interface OnFragBackListener {
        public void onFragBackPressed();
    }
}

