/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.tcaplusdb.v20190823.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class EnableRestProxyResponse extends AbstractModel {

    /**
    * RestProxy的状态，0为关闭，1为开启中，2为开启，3为关闭中
    */
    @SerializedName("RestProxyStatus")
    @Expose
    private Long RestProxyStatus;

    /**
    * TaskId由 AppInstanceId-taskId 组成，以区分不同集群的任务
    */
    @SerializedName("TaskId")
    @Expose
    private String TaskId;

    /**
    * 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
    */
    @SerializedName("RequestId")
    @Expose
    private String RequestId;

    /**
     * Get RestProxy的状态，0为关闭，1为开启中，2为开启，3为关闭中 
     * @return RestProxyStatus RestProxy的状态，0为关闭，1为开启中，2为开启，3为关闭中
     */
    public Long getRestProxyStatus() {
        return this.RestProxyStatus;
    }

    /**
     * Set RestProxy的状态，0为关闭，1为开启中，2为开启，3为关闭中
     * @param RestProxyStatus RestProxy的状态，0为关闭，1为开启中，2为开启，3为关闭中
     */
    public void setRestProxyStatus(Long RestProxyStatus) {
        this.RestProxyStatus = RestProxyStatus;
    }

    /**
     * Get TaskId由 AppInstanceId-taskId 组成，以区分不同集群的任务 
     * @return TaskId TaskId由 AppInstanceId-taskId 组成，以区分不同集群的任务
     */
    public String getTaskId() {
        return this.TaskId;
    }

    /**
     * Set TaskId由 AppInstanceId-taskId 组成，以区分不同集群的任务
     * @param TaskId TaskId由 AppInstanceId-taskId 组成，以区分不同集群的任务
     */
    public void setTaskId(String TaskId) {
        this.TaskId = TaskId;
    }

    /**
     * Get 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。 
     * @return RequestId 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
     */
    public String getRequestId() {
        return this.RequestId;
    }

    /**
     * Set 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
     * @param RequestId 唯一请求 ID，每次请求都会返回。定位问题时需要提供该次请求的 RequestId。
     */
    public void setRequestId(String RequestId) {
        this.RequestId = RequestId;
    }

    public EnableRestProxyResponse() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public EnableRestProxyResponse(EnableRestProxyResponse source) {
        if (source.RestProxyStatus != null) {
            this.RestProxyStatus = new Long(source.RestProxyStatus);
        }
        if (source.TaskId != null) {
            this.TaskId = new String(source.TaskId);
        }
        if (source.RequestId != null) {
            this.RequestId = new String(source.RequestId);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "RestProxyStatus", this.RestProxyStatus);
        this.setParamSimple(map, prefix + "TaskId", this.TaskId);
        this.setParamSimple(map, prefix + "RequestId", this.RequestId);

    }
}

