/*
 * Copyright (c) 2017-2018 THL A29 Limited, a Tencent company. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.tencentcloudapi.cwp.v20180228.models;

import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.SSEResponseModel;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;

public class DescribeMalwareWhiteListAffectListRequest extends AbstractModel {

    /**
    * 白名单规则id
    */
    @SerializedName("WhiteListId")
    @Expose
    private Long WhiteListId;

    /**
    * 偏移量，默认为0。
    */
    @SerializedName("Offset")
    @Expose
    private Long Offset;

    /**
    * 返回数量，最大值为100。
    */
    @SerializedName("Limit")
    @Expose
    private Long Limit;

    /**
    * 过滤条件。
<li>HostIp - String - 是否必填：否 - 主机ip查询 </li>
<li>FileName - String - 是否必填：否 - 文件名称查询 </li>
<li>FileDirectory - String - 是否必填：否 - 文件目录查询 </li>
<li>FileExtension - String - 是否必填：否 - 文件后缀查询 </li>
<li>Mode - String - 是否必填：否 - 规则类型 0 MD5,1自定义</li>
<li>Md5 - String - 是否必填：否 - MD5查询 </li>
    */
    @SerializedName("Filters")
    @Expose
    private Filter [] Filters;

    /**
    * 排序方式: [ASC:升序|DESC:降序]
    */
    @SerializedName("Order")
    @Expose
    private String Order;

    /**
    * 可选排序列: [CreateTime]
    */
    @SerializedName("By")
    @Expose
    private String By;

    /**
     * Get 白名单规则id 
     * @return WhiteListId 白名单规则id
     */
    public Long getWhiteListId() {
        return this.WhiteListId;
    }

    /**
     * Set 白名单规则id
     * @param WhiteListId 白名单规则id
     */
    public void setWhiteListId(Long WhiteListId) {
        this.WhiteListId = WhiteListId;
    }

    /**
     * Get 偏移量，默认为0。 
     * @return Offset 偏移量，默认为0。
     */
    public Long getOffset() {
        return this.Offset;
    }

    /**
     * Set 偏移量，默认为0。
     * @param Offset 偏移量，默认为0。
     */
    public void setOffset(Long Offset) {
        this.Offset = Offset;
    }

    /**
     * Get 返回数量，最大值为100。 
     * @return Limit 返回数量，最大值为100。
     */
    public Long getLimit() {
        return this.Limit;
    }

    /**
     * Set 返回数量，最大值为100。
     * @param Limit 返回数量，最大值为100。
     */
    public void setLimit(Long Limit) {
        this.Limit = Limit;
    }

    /**
     * Get 过滤条件。
<li>HostIp - String - 是否必填：否 - 主机ip查询 </li>
<li>FileName - String - 是否必填：否 - 文件名称查询 </li>
<li>FileDirectory - String - 是否必填：否 - 文件目录查询 </li>
<li>FileExtension - String - 是否必填：否 - 文件后缀查询 </li>
<li>Mode - String - 是否必填：否 - 规则类型 0 MD5,1自定义</li>
<li>Md5 - String - 是否必填：否 - MD5查询 </li> 
     * @return Filters 过滤条件。
<li>HostIp - String - 是否必填：否 - 主机ip查询 </li>
<li>FileName - String - 是否必填：否 - 文件名称查询 </li>
<li>FileDirectory - String - 是否必填：否 - 文件目录查询 </li>
<li>FileExtension - String - 是否必填：否 - 文件后缀查询 </li>
<li>Mode - String - 是否必填：否 - 规则类型 0 MD5,1自定义</li>
<li>Md5 - String - 是否必填：否 - MD5查询 </li>
     */
    public Filter [] getFilters() {
        return this.Filters;
    }

    /**
     * Set 过滤条件。
<li>HostIp - String - 是否必填：否 - 主机ip查询 </li>
<li>FileName - String - 是否必填：否 - 文件名称查询 </li>
<li>FileDirectory - String - 是否必填：否 - 文件目录查询 </li>
<li>FileExtension - String - 是否必填：否 - 文件后缀查询 </li>
<li>Mode - String - 是否必填：否 - 规则类型 0 MD5,1自定义</li>
<li>Md5 - String - 是否必填：否 - MD5查询 </li>
     * @param Filters 过滤条件。
<li>HostIp - String - 是否必填：否 - 主机ip查询 </li>
<li>FileName - String - 是否必填：否 - 文件名称查询 </li>
<li>FileDirectory - String - 是否必填：否 - 文件目录查询 </li>
<li>FileExtension - String - 是否必填：否 - 文件后缀查询 </li>
<li>Mode - String - 是否必填：否 - 规则类型 0 MD5,1自定义</li>
<li>Md5 - String - 是否必填：否 - MD5查询 </li>
     */
    public void setFilters(Filter [] Filters) {
        this.Filters = Filters;
    }

    /**
     * Get 排序方式: [ASC:升序|DESC:降序] 
     * @return Order 排序方式: [ASC:升序|DESC:降序]
     */
    public String getOrder() {
        return this.Order;
    }

    /**
     * Set 排序方式: [ASC:升序|DESC:降序]
     * @param Order 排序方式: [ASC:升序|DESC:降序]
     */
    public void setOrder(String Order) {
        this.Order = Order;
    }

    /**
     * Get 可选排序列: [CreateTime] 
     * @return By 可选排序列: [CreateTime]
     */
    public String getBy() {
        return this.By;
    }

    /**
     * Set 可选排序列: [CreateTime]
     * @param By 可选排序列: [CreateTime]
     */
    public void setBy(String By) {
        this.By = By;
    }

    public DescribeMalwareWhiteListAffectListRequest() {
    }

    /**
     * NOTE: Any ambiguous key set via .set("AnyKey", "value") will be a shallow copy,
     *       and any explicit key, i.e Foo, set via .setFoo("value") will be a deep copy.
     */
    public DescribeMalwareWhiteListAffectListRequest(DescribeMalwareWhiteListAffectListRequest source) {
        if (source.WhiteListId != null) {
            this.WhiteListId = new Long(source.WhiteListId);
        }
        if (source.Offset != null) {
            this.Offset = new Long(source.Offset);
        }
        if (source.Limit != null) {
            this.Limit = new Long(source.Limit);
        }
        if (source.Filters != null) {
            this.Filters = new Filter[source.Filters.length];
            for (int i = 0; i < source.Filters.length; i++) {
                this.Filters[i] = new Filter(source.Filters[i]);
            }
        }
        if (source.Order != null) {
            this.Order = new String(source.Order);
        }
        if (source.By != null) {
            this.By = new String(source.By);
        }
    }


    /**
     * Internal implementation, normal users should not use it.
     */
    public void toMap(HashMap<String, String> map, String prefix) {
        this.setParamSimple(map, prefix + "WhiteListId", this.WhiteListId);
        this.setParamSimple(map, prefix + "Offset", this.Offset);
        this.setParamSimple(map, prefix + "Limit", this.Limit);
        this.setParamArrayObj(map, prefix + "Filters.", this.Filters);
        this.setParamSimple(map, prefix + "Order", this.Order);
        this.setParamSimple(map, prefix + "By", this.By);

    }
}

