/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.sonic.sdk;

import com.tencent.sonic.sdk.SonicCacheInterceptor;
import com.tencent.sonic.sdk.SonicSessionConnectionInterceptor;
import java.util.Map;

public class SonicSessionConfig {
    int CONNECT_TIMEOUT_MILLIS = 5000;
    int READ_TIMEOUT_MILLIS = 15000;
    int READ_BUF_SIZE = 10240;
    long PRELOAD_SESSION_EXPIRED_TIME = 180000L;
    boolean ACCEPT_DIFF_DATA = true;
    boolean IS_ACCOUNT_RELATED = true;
    boolean RELOAD_IN_BAD_NETWORK = false;
    boolean AUTO_START_WHEN_CREATE = true;
    boolean SUPPORT_CACHE_CONTROL = false;
    boolean SUPPORT_LOCAL_SERVER = false;
    String USE_SONIC_CACHE_IN_BAD_NETWORK_TOAST = "Bad Network!";
    int sessionMode = 1;
    SonicCacheInterceptor cacheInterceptor = null;
    SonicSessionConnectionInterceptor connectionInterceptor = null;
    Map<String, String> customRequestHeaders = null;
    Map<String, String> customResponseHeaders = null;

    public boolean equals(Object other) {
        if (other instanceof SonicSessionConfig) {
            SonicSessionConfig config = (SonicSessionConfig)other;
            return this.sessionMode == config.sessionMode && this.SUPPORT_LOCAL_SERVER == config.SUPPORT_LOCAL_SERVER;
        }
        return false;
    }

    private SonicSessionConfig() {
    }

    public static class Builder {
        private final SonicSessionConfig target = new SonicSessionConfig();

        public Builder setConnectTimeoutMillis(int connectTimeoutMillis) {
            this.target.CONNECT_TIMEOUT_MILLIS = connectTimeoutMillis;
            return this;
        }

        public Builder setReadTimeoutMillis(int readTimeoutMillis) {
            this.target.READ_TIMEOUT_MILLIS = readTimeoutMillis;
            return this;
        }

        public Builder setReadBufferSize(int readBufferSize) {
            this.target.READ_BUF_SIZE = readBufferSize;
            return this;
        }

        public Builder setPreloadSessionExpiredTimeMillis(long preloadSessionExpiredTimeMillis) {
            this.target.PRELOAD_SESSION_EXPIRED_TIME = preloadSessionExpiredTimeMillis;
            return this;
        }

        public Builder setAcceptDiff(boolean enable) {
            this.target.ACCEPT_DIFF_DATA = enable;
            return this;
        }

        public Builder setIsAccountRelated(boolean value) {
            this.target.IS_ACCOUNT_RELATED = value;
            return this;
        }

        public Builder setReloadInBadNetwork(boolean reloadInBadNetwork) {
            this.target.RELOAD_IN_BAD_NETWORK = reloadInBadNetwork;
            return this;
        }

        public Builder setAutoStartWhenCreate(boolean autoStartWhenCreate) {
            this.target.AUTO_START_WHEN_CREATE = autoStartWhenCreate;
            return this;
        }

        public Builder setUseSonicCacheInBadNetworkToastMessage(String toastMessage) {
            this.target.USE_SONIC_CACHE_IN_BAD_NETWORK_TOAST = toastMessage;
            return this;
        }

        public Builder setSessionMode(int sessionMode) {
            this.target.sessionMode = sessionMode;
            return this;
        }

        public Builder setCacheInterceptor(SonicCacheInterceptor interceptor) {
            this.target.cacheInterceptor = interceptor;
            return this;
        }

        public Builder setConnectionInterceptor(SonicSessionConnectionInterceptor interceptor) {
            this.target.connectionInterceptor = interceptor;
            return this;
        }

        public Builder setCustomRequestHeaders(Map<String, String> customRequestHeaders) {
            this.target.customRequestHeaders = customRequestHeaders;
            return this;
        }

        public Builder setCustomResponseHeaders(Map<String, String> customResponseHeaders) {
            this.target.customResponseHeaders = customResponseHeaders;
            return this;
        }

        public Builder setSupportCacheControl(boolean supportCacheControl) {
            this.target.SUPPORT_CACHE_CONTROL = supportCacheControl;
            return this;
        }

        public Builder setSupportLocalServer(boolean enable) {
            this.target.SUPPORT_LOCAL_SERVER = enable;
            return this;
        }

        public SonicSessionConfig build() {
            return this.target;
        }
    }
}

