/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.sonic.sdk;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import com.tencent.sonic.sdk.SonicEngine;
import com.tencent.sonic.sdk.SonicUtils;
import java.util.concurrent.atomic.AtomicBoolean;

public class SonicDBHelper
extends SQLiteOpenHelper {
    private static final String TAG = "SonicSdk_SonicDBHelper";
    private static final String SONIC_DATABASE_NAME = "sonic.db";
    private static final int SONIC_DATABASE_VERSION = 1;
    protected static final String Sonic_SESSION_TABLE_NAME = "SessionData";
    protected static final String SESSION_DATA_COLUMN_SESSION_ID = "sessionID";
    protected static final String SESSION_DATA_COLUMN_ETAG = "eTag";
    protected static final String SESSION_DATA_COLUMN_TEMPLATE_EAG = "templateTag";
    protected static final String SESSION_DATA_COLUMN_HTML_SHA1 = "htmlSha1";
    protected static final String SESSION_DATA_COLUMN_HTML_SIZE = "htmlSize";
    protected static final String SESSION_DATA_COLUMN_TEMPLATE_UPDATE_TIME = "templateUpdateTime";
    protected static final String SESSION_DATA_COLUMN_UNAVAILABLE_TIME = "UnavailableTime";
    protected static final String SESSION_DATA_COLUMN_CACHE_EXPIRED_TIME = "cacheExpiredTime";
    protected static final String SESSION_DATA_COLUMN_CACHE_HIT_COUNT = "cacheHitCount";
    private static SonicDBHelper sInstance = null;
    private static AtomicBoolean isDBUpgrading = new AtomicBoolean(false);

    private SonicDBHelper(Context context) {
        super(context, SONIC_DATABASE_NAME, null, 1);
    }

    static synchronized SonicDBHelper createInstance(Context context) {
        if (null == sInstance) {
            sInstance = new SonicDBHelper(context);
        }
        return sInstance;
    }

    public static synchronized SonicDBHelper getInstance() {
        if (null == sInstance) {
            throw new IllegalStateException("SonicDBHelper::createInstance() needs to be called before SonicDBHelper::getInstance()!");
        }
        return sInstance;
    }

    static String[] getAllSessionDataColumn() {
        return new String[]{SESSION_DATA_COLUMN_SESSION_ID, SESSION_DATA_COLUMN_ETAG, SESSION_DATA_COLUMN_TEMPLATE_EAG, SESSION_DATA_COLUMN_HTML_SHA1, SESSION_DATA_COLUMN_UNAVAILABLE_TIME, SESSION_DATA_COLUMN_HTML_SIZE, SESSION_DATA_COLUMN_TEMPLATE_UPDATE_TIME, SESSION_DATA_COLUMN_CACHE_EXPIRED_TIME, SESSION_DATA_COLUMN_CACHE_HIT_COUNT};
    }

    public void onCreate(SQLiteDatabase db) {
        String createTableSql = "CREATE TABLE IF NOT EXISTS SessionData ( id  integer PRIMARY KEY autoincrement , sessionID text not null , eTag text not null , templateTag text , htmlSha1 text not null , UnavailableTime integer default 0 , htmlSize integer default 0 , templateUpdateTime integer default 0 , cacheExpiredTime integer default 0 , cacheHitCount integer default 0 ); ";
        db.execSQL(createTableSql);
        this.onUpgrade(db, -1, 1);
    }

    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        if (isDBUpgrading.compareAndSet(false, true)) {
            long startTime = System.currentTimeMillis();
            SonicUtils.log(TAG, 4, "onUpgrade start, from " + oldVersion + " to " + newVersion + ".");
            if (-1 == oldVersion) {
                SonicEngine.getInstance().getRuntime().postTaskToThread(new Runnable(){

                    @Override
                    public void run() {
                        SonicUtils.removeAllSessionCache();
                        isDBUpgrading.set(false);
                    }
                }, 0L);
            } else {
                this.doUpgrade(db, oldVersion, newVersion);
                isDBUpgrading.set(false);
            }
            SonicUtils.log(TAG, 4, "onUpgrade finish, cost " + (System.currentTimeMillis() - startTime) + "ms.");
        }
    }

    private void doUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
    }

    public boolean isUpgrading() {
        return isDBUpgrading.get();
    }
}

