/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tencentmap.mapsdk.maps.model;

import android.graphics.Color;
import android.graphics.Typeface;
import android.os.Parcel;
import com.tencent.tencentmap.mapsdk.maps.model.LatLng;
import com.tencent.tencentmap.mapsdk.maps.model.OverlayLevel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PolygonOptions {
    private static final int COLOR_DEFAULT_POLYGON = Color.argb((int)200, (int)0, (int)163, (int)255);
    private final List<LatLng> listPts;
    private float fStrokeWidth = 1.0f;
    private int iStrokeColor = -16777216;
    private int iFillColor;
    private int iZindex = 0;
    private boolean boIsVisble = true;
    private boolean boIsGeoDes = false;
    private String mText = "";
    private int mTextColor = -16777216;
    private Typeface mTypeface = Typeface.DEFAULT;
    private int mMaxTextSize = Integer.MAX_VALUE;
    private int mMinTextSize = 1;
    private int mTextSize = -1;
    private boolean mClickable;
    private int iLevel = OverlayLevel.OverlayLevelAboveLabels;

    public PolygonOptions() {
        this.iFillColor = COLOR_DEFAULT_POLYGON;
        this.listPts = new ArrayList<LatLng>();
    }

    public void setPoints(Iterable<LatLng> points) {
        this.listPts.clear();
        if (points == null) {
            return;
        }
        this.addAll(points);
    }

    public PolygonOptions add(LatLng latLng) {
        if (latLng != null) {
            this.listPts.add(latLng);
        }
        return this;
    }

    public PolygonOptions add(LatLng ... latLngs) {
        if (latLngs != null) {
            this.listPts.addAll(Arrays.asList(latLngs));
        }
        return this;
    }

    public PolygonOptions add(List<LatLng> points) {
        if (points != null) {
            this.listPts.addAll(points);
        }
        return this;
    }

    public PolygonOptions addAll(Iterable<LatLng> latLngs) {
        if (latLngs != null) {
            for (LatLng latlng : latLngs) {
                this.listPts.add(latlng);
            }
        }
        return this;
    }

    public PolygonOptions strokeWidth(float strokeWidth) {
        this.fStrokeWidth = strokeWidth < 0.0f ? 1.0f : strokeWidth;
        return this;
    }

    public PolygonOptions strokeColor(int strokeColor) {
        this.iStrokeColor = strokeColor;
        return this;
    }

    public PolygonOptions fillColor(int fillColor) {
        this.iFillColor = fillColor;
        return this;
    }

    public PolygonOptions zIndex(int zIndex) {
        this.iZindex = zIndex;
        return this;
    }

    public PolygonOptions visible(boolean flag) {
        this.boIsVisble = flag;
        return this;
    }

    public PolygonOptions clickable(boolean clickable) {
        this.mClickable = clickable;
        return this;
    }

    public void writeToParcel(Parcel out, int flags) {
        if (out == null) {
            return;
        }
        out.writeInt(this.iFillColor);
    }

    private PolygonOptions geodesic(boolean flag) {
        this.boIsGeoDes = flag;
        return this;
    }

    public List<LatLng> getPoints() {
        return this.listPts;
    }

    public float getStrokeWidth() {
        return this.fStrokeWidth;
    }

    public int getStrokeColor() {
        return this.iStrokeColor;
    }

    public int getFillColor() {
        return this.iFillColor;
    }

    public float getZIndex() {
        return this.iZindex;
    }

    public boolean isVisible() {
        return this.boIsVisble;
    }

    private boolean isGeodesic() {
        return this.boIsGeoDes;
    }

    public boolean isClickable() {
        return this.mClickable;
    }

    PolygonOptions text(String text) {
        this.mText = text;
        return this;
    }

    public String getText() {
        return this.mText;
    }

    PolygonOptions textColor(int color) {
        this.mTextColor = color;
        return this;
    }

    int getTextColor() {
        return this.mTextColor;
    }

    PolygonOptions textTypeface(Typeface typeface) {
        this.mTypeface = typeface;
        return this;
    }

    Typeface getTypeface() {
        return this.mTypeface;
    }

    PolygonOptions maxTextSize(int size) {
        this.mMaxTextSize = size;
        return this;
    }

    int getMaxTextSize() {
        return this.mMaxTextSize;
    }

    PolygonOptions minTextSize(int size) {
        this.mMinTextSize = size;
        return this;
    }

    int getMinTextSize() {
        return this.mMinTextSize;
    }

    PolygonOptions textSize(int size) {
        this.mTextSize = size;
        return this;
    }

    private int getTextSize() {
        return this.mTextSize;
    }

    public PolygonOptions level(int level) {
        if (level < OverlayLevel.OverlayLevelAboveRoads || level > OverlayLevel.OverlayLevelAboveLabels) {
            return this;
        }
        this.iLevel = level;
        return this;
    }

    public int getLevel() {
        return this.iLevel;
    }
}

