/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tencentmap.mapsdk.maps.model;

import com.tencent.tencentmap.mapsdk.maps.model.IndoorLevel;
import com.tencent.tencentmap.mapsdk.maps.model.LatLng;
import java.util.ArrayList;
import java.util.List;

public final class IndoorBuilding
implements Cloneable {
    private String mBuidlingId;
    private String mBuildingName;
    private int mActiveLevelIndex;
    private List<IndoorLevel> mLevels;
    private LatLng mLatLng;

    public IndoorBuilding(String buildingId, String name, LatLng latLng, List<IndoorLevel> indoorLevels, int activeIndex) {
        this.mBuidlingId = buildingId;
        this.mBuildingName = name;
        this.mLatLng = latLng;
        this.mLevels = indoorLevels;
        this.mActiveLevelIndex = activeIndex;
    }

    public final String getBuidlingId() {
        return this.mBuidlingId;
    }

    public final String getBuildingName() {
        return this.mBuildingName;
    }

    public final List<IndoorLevel> getLevels() {
        return this.mLevels;
    }

    public final int getActiveLevelIndex() {
        return this.mActiveLevelIndex;
    }

    public final LatLng getBuildingLatLng() {
        return this.mLatLng;
    }

    public final String toString() {
        if (this.mBuidlingId == null || this.mLevels == null || this.mLevels.size() <= this.mActiveLevelIndex) {
            return "";
        }
        return this.mBuidlingId + "_" + this.mLevels.get(this.mActiveLevelIndex).getName();
    }

    protected final Object clone() throws CloneNotSupportedException {
        IndoorBuilding indoorBuilding = (IndoorBuilding)super.clone();
        if (this.mLevels != null) {
            indoorBuilding.mLevels = new ArrayList<IndoorLevel>(this.mLevels.size());
            for (int i2 = 0; i2 < this.mLevels.size(); ++i2) {
                indoorBuilding.mLevels.add(new IndoorLevel(this.mLevels.get(i2).getName()));
            }
        }
        if (this.mLatLng != null) {
            indoorBuilding.mLatLng = new LatLng(this.mLatLng.latitude, this.mLatLng.longitude);
        }
        return indoorBuilding;
    }
}

