/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tencentmap.mapsdk.maps.model;

import com.tencent.tencentmap.mapsdk.maps.model.BitmapDescriptor;
import com.tencent.tencentmap.mapsdk.maps.model.LatLng;
import com.tencent.tencentmap.mapsdk.maps.model.LatLngBounds;
import com.tencent.tencentmap.mapsdk.maps.model.OverlayLevel;

public final class GroundOverlayOptions {
    private BitmapDescriptor mBitmapDescriptor;
    private LatLngBounds mLatLngBounds;
    private LatLng mPosition;
    private float mZoom = 18.0f;
    private float mAnchorU = 0.5f;
    private float mAnchorV = 0.5f;
    private float mAlpha = 1.0f;
    private boolean mVisibility = true;
    private int mZIndex;
    private int mLevel = OverlayLevel.OverlayLevelAboveBuildings;

    public final BitmapDescriptor getBitmap() {
        return this.mBitmapDescriptor;
    }

    public final GroundOverlayOptions bitmap(BitmapDescriptor bitmapDescriptor) {
        this.mBitmapDescriptor = bitmapDescriptor;
        return this;
    }

    public final LatLngBounds getLatLngBounds() {
        return this.mLatLngBounds;
    }

    public final GroundOverlayOptions latLngBounds(LatLngBounds latLngBounds) {
        this.mLatLngBounds = latLngBounds;
        return this;
    }

    public final LatLng getPosition() {
        return this.mPosition;
    }

    public final GroundOverlayOptions position(LatLng position) {
        this.mPosition = position;
        return this;
    }

    public final float getZoom() {
        return this.mZoom;
    }

    public final GroundOverlayOptions zoom(float zoom) {
        this.mZoom = zoom;
        return this;
    }

    public final float getAnchorU() {
        return this.mAnchorU;
    }

    public final float getAnchorV() {
        return this.mAnchorV;
    }

    public final GroundOverlayOptions anchor(float anchorU, float anchorV) {
        this.mAnchorU = anchorU;
        this.mAnchorV = anchorV;
        return this;
    }

    public final float getAlpha() {
        return this.mAlpha;
    }

    public final GroundOverlayOptions alpha(float alpha) {
        this.mAlpha = alpha;
        return this;
    }

    public final boolean isVisible() {
        return this.mVisibility;
    }

    public final GroundOverlayOptions visible(boolean visible) {
        this.mVisibility = visible;
        return this;
    }

    public final int getZIndex() {
        return this.mZIndex;
    }

    public final GroundOverlayOptions zIndex(int ZIndex) {
        this.mZIndex = ZIndex;
        return this;
    }

    public final int getLevel() {
        return this.mLevel;
    }

    public final GroundOverlayOptions level(int level) {
        if (level < OverlayLevel.OverlayLevelAboveRoads || level > OverlayLevel.OverlayLevelAboveLabels) {
            return this;
        }
        this.mLevel = level;
        return this;
    }

    public final boolean isValid() {
        return this.mBitmapDescriptor != null && (this.mLatLngBounds != null || this.mPosition != null);
    }
}

