/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tencentmap.mapsdk.maps.model;

import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.view.View;
import com.tencent.tencentmap.mapsdk.maps.model.LatLng;
import com.tencent.tencentmap.mapsdk.maps.model.Marker;

public class BubbleOptions {
    private Marker mMarker;
    private String mContent;
    private LatLng mPosition;
    private int mMarkerWidth = 0;
    private int mMarkerHeight = 0;
    private float mMarkerAnchorU = 0.5f;
    private float mMarkerAnchorV = 0.5f;
    private int mDisplayLevel = 0;
    private View mContentView;
    private Drawable[] mBackground = null;
    private boolean mOnTapHidden = false;

    public BubbleOptions marker(Marker marker) {
        this.mMarker = marker;
        this.position(marker.getPosition());
        this.markerAnchor(marker.getAnchorU(), marker.getAnchorV());
        return this;
    }

    public Marker getMarker() {
        return this.mMarker;
    }

    public BubbleOptions markerSize(int width, int height) {
        this.mMarkerWidth = width;
        this.mMarkerHeight = height;
        return this;
    }

    public int getMarkerWidth() {
        return this.mMarkerWidth;
    }

    public int getMarkerHeight() {
        return this.mMarkerHeight;
    }

    public BubbleOptions markerAnchor(float anchorU, float anchorV) {
        this.mMarkerAnchorU = anchorU;
        this.mMarkerAnchorV = anchorV;
        return this;
    }

    public float getMarkerAnchorU() {
        return this.mMarkerAnchorU;
    }

    public float getMarkerAnchorV() {
        return this.mMarkerAnchorV;
    }

    public BubbleOptions content(String content) {
        this.mContent = content;
        return this;
    }

    public String getContent() {
        return this.mContent;
    }

    public BubbleOptions position(LatLng position) {
        this.mPosition = position;
        return this;
    }

    public LatLng getPosition() {
        return this.mPosition;
    }

    public BubbleOptions displayLevel(int level) {
        if (level < 0) {
            level = 0;
        }
        this.mDisplayLevel = level;
        return this;
    }

    public int getDisplayLevel() {
        return this.mDisplayLevel;
    }

    public BubbleOptions contentView(View view) {
        this.mContentView = view;
        return this;
    }

    public View getContentView() {
        return this.mContentView;
    }

    public BubbleOptions background(Drawable[] background) {
        this.mBackground = background;
        return this;
    }

    public BubbleOptions background(Bitmap[] background) {
        if (background != null) {
            this.mBackground = new Drawable[4];
            int size = background.length;
            for (int i2 = 0; i2 < size; ++i2) {
                this.mBackground[i2] = new BitmapDrawable(background[i2]);
            }
        }
        return this;
    }

    public Drawable[] getBackground() {
        return this.mBackground;
    }

    public BubbleOptions setOnTapHidden(boolean hidden) {
        this.mOnTapHidden = hidden;
        return this;
    }

    public boolean getOnTapHidden() {
        return this.mOnTapHidden;
    }
}

