/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.map.lib.models;

import android.support.annotation.Keep;
import com.tencent.map.lib.models.SubMarkerInfo;
import com.tencent.tencentmap.mapsdk.maps.model.OverlayLevel;

@Keep
public class MarkerInfo {
    public static final int TYPE_2D_GEO_ANGLE = 0;
    public static final int TYPE_2D_SCREEN_ANGLE = 1;
    public static final int TYPE_2D_UI = 2;
    public static final int TYPE_3D = 3;
    private int type = 1;
    private String iconName;
    private double latitude;
    private double longitude;
    private float anchorX = 0.5f;
    private float anchorY = 0.5f;
    private float angle = 0.0f;
    private float alpha = 1.0f;
    private float scaleX = 1.0f;
    private float scaleY = 1.0f;
    private boolean avoidAnnotation = false;
    private boolean interactive = true;
    private int displayLevel = OverlayLevel.OverlayLevelAboveRoads;
    private int priority;
    private boolean forceLoad = true;
    private int minScaleLevel = 0;
    private int maxScaleLevel = 30;
    private boolean visibility = true;
    private boolean avoidOtherMarker = false;
    private int iconWidth;
    private int iconHeight;
    private SubMarkerInfo mSubMarkerInfo;

    private MarkerInfo() {
    }

    public MarkerInfo(double latitude, double longitude, String iconName) {
        this.latitude = latitude;
        this.longitude = longitude;
        this.iconName = iconName;
    }

    public MarkerInfo position(double latitude, double longitude) {
        this.latitude = latitude;
        this.longitude = longitude;
        return this;
    }

    public MarkerInfo iconName(String iconName) {
        this.iconName = iconName;
        return this;
    }

    public MarkerInfo type(int type) {
        this.type = type;
        return this;
    }

    public MarkerInfo anchor(float x2, float y2) {
        this.anchorX = x2;
        this.anchorY = y2;
        return this;
    }

    public MarkerInfo rotation(float rotation) {
        this.angle = rotation;
        return this;
    }

    public MarkerInfo alpha(float alpha) {
        this.alpha = alpha;
        return this;
    }

    public MarkerInfo scale(float x2, float y2) {
        this.scaleX = x2;
        this.scaleY = y2;
        return this;
    }

    public MarkerInfo avoidAnnotation(boolean avoidAnnotation) {
        this.avoidAnnotation = avoidAnnotation;
        return this;
    }

    public MarkerInfo interactive(boolean interactive) {
        this.interactive = interactive;
        return this;
    }

    public MarkerInfo displayLevel(int level) {
        this.displayLevel = level;
        return this;
    }

    public MarkerInfo priority(int priority) {
        this.priority = priority;
        return this;
    }

    public MarkerInfo forceLoad(boolean forceLoad) {
        this.forceLoad = forceLoad;
        return this;
    }

    public MarkerInfo minScaleLevel(int scaleLevel) {
        this.minScaleLevel = scaleLevel;
        return this;
    }

    public MarkerInfo maxScaleLevel(int scaleLevel) {
        this.maxScaleLevel = scaleLevel;
        return this;
    }

    public MarkerInfo visible(boolean visibility) {
        this.visibility = visibility;
        return this;
    }

    public MarkerInfo avoidOtherMarker(boolean isAvoid) {
        this.avoidOtherMarker = isAvoid;
        return this;
    }

    public MarkerInfo subMarkerInfo(SubMarkerInfo subMarkerInfo) {
        this.mSubMarkerInfo = subMarkerInfo;
        return this;
    }

    public MarkerInfo iconWidth(int iconWidth) {
        this.iconWidth = iconWidth;
        return this;
    }

    public MarkerInfo iconHeight(int iconHeight) {
        this.iconHeight = iconHeight;
        return this;
    }

    public String toString() {
        return "MarkerInfo{type=" + this.type + ", iconName='" + this.iconName + '\'' + ", latitude=" + this.latitude + ", longitude=" + this.longitude + ", anchorX=" + this.anchorX + ", anchorY=" + this.anchorY + ", angle=" + this.angle + ", alpha=" + this.alpha + ", scaleX=" + this.scaleX + ", scaleY=" + this.scaleY + ", avoidAnnotation=" + this.avoidAnnotation + ", interactive=" + this.interactive + ", displayLevel=" + this.displayLevel + ", priority=" + this.priority + ", forceLoad=" + this.forceLoad + ", minScaleLevel=" + this.minScaleLevel + ", maxScaleLevel=" + this.maxScaleLevel + ", visibility=" + this.visibility + ", avoidOtherMarker=" + this.avoidOtherMarker + ", iconWidth=" + this.iconWidth + ", iconHeight=" + this.iconHeight + ", mSubMarkerInfo=" + this.mSubMarkerInfo + '}';
    }
}

