/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.rtmp.video;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.media.projection.MediaProjection;
import android.media.projection.MediaProjectionManager;
import android.os.Bundle;
import android.os.Parcelable;
import com.tencent.rtmp.video.BaseBridge;
import com.tencent.rtmp.video.ScreenCaptureService;
import com.tencent.rtmp.video.VirtualDisplayManagerProxy;

public class TXScreenCapture {

    public static class TXScreenCaptureAssistantActivity
    extends Activity {
        private static final String TAG = "TXScreenCaptureAssistantActivity";
        private static final int REQUEST_CODE = 100;
        private MediaProjectionManager mMediaProjectionManager;
        private volatile boolean mIsStop = false;

        public void onCreate(Bundle savedInstanceState) {
            super.onCreate(savedInstanceState);
            BaseBridge.printLog(TAG, "onCreate ".concat(String.valueOf((Object)this)));
            this.requestWindowFeature(1);
            this.mMediaProjectionManager = (MediaProjectionManager)this.getSystemService("media_projection");
            Intent intent = this.mMediaProjectionManager.createScreenCaptureIntent();
            try {
                this.startActivityForResult(intent, 100);
                VirtualDisplayManagerProxy.getInstance().registerRequestPermissionActivity(this);
                return;
            }
            catch (Throwable throwable) {
                BaseBridge.printLog(TAG, "Start permission activity failed. ".concat(String.valueOf(throwable)));
                VirtualDisplayManagerProxy.getInstance().signalSessionRequestFinish(null);
                this.finish();
                return;
            }
        }

        public boolean isStop() {
            return this.mIsStop;
        }

        protected void onStart() {
            super.onStart();
            this.mIsStop = false;
            BaseBridge.printLog(TAG, "onStart:".concat(String.valueOf((Object)this)));
        }

        protected void onStop() {
            super.onStop();
            this.mIsStop = true;
            BaseBridge.printLog(TAG, "onStop:".concat(String.valueOf((Object)this)));
        }

        public void onActivityResult(int requestCode, int resultCode, Intent data) {
            BaseBridge.printLog(TAG, "onActivityResult " + (Object)((Object)this) + ", resultCode:" + resultCode + ", data:" + data);
            if (data == null) {
                VirtualDisplayManagerProxy.getInstance().signalSessionRequestFinish(null);
                this.finish();
                return;
            }
            if (BaseBridge.getSystemOSVersion() >= 26) {
                BaseBridge.printLog(TAG, "startForegroundService");
                Intent intent = new Intent((Context)this, ScreenCaptureService.class);
                intent.putExtra("code", resultCode);
                intent.putExtra("data", (Parcelable)data);
                this.startForegroundService(intent);
            } else {
                MediaProjection mediaProjection = null;
                try {
                    mediaProjection = this.mMediaProjectionManager.getMediaProjection(resultCode, data);
                }
                catch (Throwable throwable) {
                    BaseBridge.printLog(TAG, "onActivityResult mMediaProjectionManager.getMediaProjection fail.".concat(String.valueOf(throwable)));
                }
                BaseBridge.printLog(TAG, "ProjectionManger get mediaProjection:".concat(String.valueOf(mediaProjection)));
                VirtualDisplayManagerProxy.getInstance().signalSessionRequestFinish(mediaProjection);
            }
            this.finish();
        }

        protected void onDestroy() {
            BaseBridge.printLog(TAG, "onDestroy ".concat(String.valueOf((Object)this)));
            VirtualDisplayManagerProxy.getInstance().unRegisterRequestPermissionActivity(this);
            super.onDestroy();
        }
    }
}

