/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc.videoprocessor.videoeffect.filter;

import android.graphics.Bitmap;
import android.opengl.GLES20;
import com.tencent.ugc.videobase.chain.TXCGPUImageFilter;
import com.tencent.ugc.videobase.frame.GLTexturePool;
import com.tencent.ugc.videobase.utils.OpenGlUtils;

public class TXCGPULookUpFilter
extends TXCGPUImageFilter {
    protected Bitmap m_bmp = null;
    public int mLookupTextureUniform;
    public int mLookupSourceTexture = -1;
    protected int mIntensityLocation = -1;
    protected float mIntensity;
    private static final String LookupFilterFragmentShader = "varying highp vec2 textureCoordinate;\n \n uniform sampler2D inputImageTexture;\n uniform sampler2D inputImageTexture2; // lookup texture\n \n \n uniform lowp float intensity;\n \n void main()\n {\n     lowp vec4 textureColor = texture2D(inputImageTexture, textureCoordinate);\n     \n     mediump float blueColor = textureColor.b * 63.0;\n     \n     mediump vec2 quad1;\n     quad1.y = floor(floor(blueColor) / 8.0);\n     quad1.x = floor(blueColor) - (quad1.y * 8.0);\n     \n     mediump vec2 quad2;\n     quad2.y = floor(ceil(blueColor) / 8.0);\n     quad2.x = ceil(blueColor) - (quad2.y * 8.0);\n     \n     highp vec2 texPos1;\n     texPos1.x = (quad1.x * 0.125) + 0.5/512.0 + ((0.125 - 1.0/512.0) * textureColor.r);\n     texPos1.y = (quad1.y * 0.125) + 0.5/512.0 + ((0.125 - 1.0/512.0) * textureColor.g);\n     \n     highp vec2 texPos2;\n     texPos2.x = (quad2.x * 0.125) + 0.5/512.0 + ((0.125 - 1.0/512.0) * textureColor.r);\n     texPos2.y = (quad2.y * 0.125) + 0.5/512.0 + ((0.125 - 1.0/512.0) * textureColor.g);\n     \n     lowp vec4 newColor1 = texture2D(inputImageTexture2, texPos1);\n     lowp vec4 newColor2 = texture2D(inputImageTexture2, texPos2);\n     \n     lowp vec4 newColor = mix(newColor1, newColor2, fract(blueColor));\n     gl_FragColor = mix(textureColor, vec4(newColor.rgb, textureColor.w), intensity);\n }";

    public TXCGPULookUpFilter(Bitmap bmp) {
        this("attribute vec4 position;\nattribute vec4 inputTextureCoordinate;\nuniform mat4 textureTransform;\nvarying highp vec2 textureCoordinate;\nvoid main()\n{\n    gl_Position = position;\n    textureCoordinate = (textureTransform * inputTextureCoordinate).xy;\n}", LookupFilterFragmentShader);
        this.m_bmp = bmp;
    }

    public TXCGPULookUpFilter(String vertString, String fragString) {
        super(vertString, fragString);
    }

    @Override
    public void onInit(GLTexturePool texturePool) {
        this.mLookupTextureUniform = GLES20.glGetUniformLocation((int)this.getProgramId(), (String)"inputImageTexture2");
        this.mIntensityLocation = GLES20.glGetUniformLocation((int)this.getProgramId(), (String)"intensity");
        this.mIntensity = 0.5f;
        TXCGPULookUpFilter tXCGPULookUpFilter = this;
        tXCGPULookUpFilter.setBitmap(tXCGPULookUpFilter.m_bmp);
        TXCGPULookUpFilter tXCGPULookUpFilter2 = this;
        tXCGPULookUpFilter2.setIntensity(tXCGPULookUpFilter2.mIntensity);
    }

    public void setBitmap(final Bitmap bitmap) {
        this.runOnDraw(new Runnable(){

            @Override
            public final void run() {
                if (bitmap != null) {
                    TXCGPULookUpFilter.this.mLookupSourceTexture = OpenGlUtils.loadTexture(bitmap, TXCGPULookUpFilter.this.mLookupSourceTexture, false);
                }
            }
        });
    }

    public void setIntensity(float intensity) {
        this.mIntensity = intensity;
        TXCGPULookUpFilter tXCGPULookUpFilter = this;
        tXCGPULookUpFilter.setFloatOnDraw(tXCGPULookUpFilter.mIntensityLocation, this.mIntensity);
    }

    public void onDestroy() {
        int[] nArray = new int[]{this.mLookupSourceTexture};
        GLES20.glDeleteTextures((int)1, (int[])nArray, (int)0);
        this.mLookupSourceTexture = -1;
        super.uninitialize();
    }

    @Override
    public void beforeDrawArrays(int textureId) {
        if (this.mLookupSourceTexture != -1) {
            GLES20.glActiveTexture((int)33987);
            GLES20.glBindTexture((int)3553, (int)0);
            GLES20.glActiveTexture((int)33984);
        }
    }

    @Override
    public void afterDrawArrays() {
        if (this.mLookupSourceTexture != -1) {
            GLES20.glActiveTexture((int)33987);
            GLES20.glBindTexture((int)3553, (int)this.mLookupSourceTexture);
            GLES20.glUniform1i((int)this.mLookupTextureUniform, (int)3);
        }
    }
}

