/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc.videoprocessor.videoeffect.filter;

import android.opengl.GLES20;
import com.tencent.ugc.videobase.frame.GLTexturePool;
import com.tencent.ugc.videoprocessor.videoeffect.TXCGPUEffectFilterBase;

public class TXCGPULinearShadowFilter
extends TXCGPUEffectFilterBase {
    private static final int DURATION_WIN_SHADDOW_LV1 = 300;
    private static final int DURATION_WIN_SHADDOW_LV2 = 350;
    private static final int DURATION_WIN_SHADDOW_LV3 = 400;
    private static final int DURATION_WIN_SHADDOW_LV4 = 500;
    private static final int DURATION_WIN_SHADDOW_LV5 = 600;
    private static final int DURATION_WIN_SHADDOW_LV6 = 650;
    private static final int DURATION_WIN_SHADDOW_LV7 = 700;
    private static final int DURATION_WIN_SHADDOW_LV8 = 800;
    private static final int DURATION_WIN_SHADDOW_LV9 = 900;
    private static final int DURATION_WIN_SHADDOW_LV10 = 1000;
    private static final int DURATION_WIN_SHADDOW_LV11 = 1050;
    private static final int DURATION_WIN_SHADDOW_LV12 = 1100;
    private static final int DURATION_WIN_SHADDOW_LV13 = 1200;
    private static final int DURATION_WIN_SHADDOW_LV14 = 1500;
    private static final int DURATION_WIN_SHADDOW_LV15 = 2500;
    private static final String FRAGMENT_SHADER = "precision mediump float; \nvarying highp vec2 textureCoordinate; \nuniform sampler2D inputImageTexture; \n \nuniform float a; \nuniform float b; \nuniform float c; \nuniform float d; \nuniform float mode; \nuniform float width; \nuniform float stride; \nuniform float alpha; \n \nvoid main() \n{ \n\tgl_FragColor = texture2D(inputImageTexture, textureCoordinate); \n   if(b == 0.0){ \n\t\tfloat mx = mod(textureCoordinate.x + c, stride); \n\t\tif((mode < 0.5 && mx <= width) || (mode > 0.5 && (mx > width))){ \n\t\t\tgl_FragColor.rgb = gl_FragColor.rgb*alpha; \n\t\t} \n\t} \n} \n";
    private LinearShadowParam mLinearShadowParm;
    private int mCPos = -1;
    private int mModePos = -1;
    private int mWithPos = -1;
    private int mStridePos = -1;
    private int mAlphaPos = -1;

    public TXCGPULinearShadowFilter() {
        super("attribute vec4 position;\nattribute vec4 inputTextureCoordinate;\nuniform mat4 textureTransform;\nvarying highp vec2 textureCoordinate;\nvoid main()\n{\n    gl_Position = position;\n    textureCoordinate = (textureTransform * inputTextureCoordinate).xy;\n}", FRAGMENT_SHADER);
    }

    @Override
    public void onOutputSizeChanged(int width, int height) {
        super.onOutputSizeChanged(width, height);
    }

    @Override
    public void onInit(GLTexturePool texturePool) {
        super.onInit(texturePool);
        this.mCPos = GLES20.glGetUniformLocation((int)this.getProgramId(), (String)"c");
        this.mModePos = GLES20.glGetUniformLocation((int)this.getProgramId(), (String)"mode");
        this.mWithPos = GLES20.glGetUniformLocation((int)this.getProgramId(), (String)"width");
        this.mStridePos = GLES20.glGetUniformLocation((int)this.getProgramId(), (String)"stride");
        this.mAlphaPos = GLES20.glGetUniformLocation((int)this.getProgramId(), (String)"alpha");
    }

    @Override
    public void setNextFrameTimestamp(long pts) {
        long l2;
        super.setNextFrameTimestamp(pts);
        if (this.mLinearShadowParm == null) {
            this.mLinearShadowParm = new LinearShadowParam();
        }
        if ((l2 = Math.abs(pts - this.mEffectStartTime)) < 300L) {
            this.mLinearShadowParm.alpha = 0.0f;
            this.mLinearShadowParm.stride = 0.03f;
            this.mLinearShadowParm.width = 0.003f;
        } else if (l2 < 350L) {
            this.mLinearShadowParm.alpha = 0.0f;
            this.mLinearShadowParm.stride = 0.03f;
            this.mLinearShadowParm.width = 0.015f;
        } else if (l2 < 400L) {
            this.mLinearShadowParm.alpha = 0.0f;
            this.mLinearShadowParm.stride = 0.03f;
            this.mLinearShadowParm.width = 0.024f;
        } else if (l2 < 500L) {
            this.mLinearShadowParm.alpha = 0.0f;
            this.mLinearShadowParm.stride = 0.03f;
            this.mLinearShadowParm.width = 0.015f;
        } else if (l2 < 600L) {
            this.mLinearShadowParm.alpha = 0.0f;
            this.mLinearShadowParm.stride = 0.03f;
            this.mLinearShadowParm.width = 0.003f;
        } else if (l2 < 650L) {
            this.mLinearShadowParm.alpha = 0.0f;
            this.mLinearShadowParm.stride = 0.03f;
            this.mLinearShadowParm.width = 0.03f;
        } else if (l2 < 700L) {
            this.mLinearShadowParm.alpha = 0.0f;
            this.mLinearShadowParm.stride = 0.03f;
            this.mLinearShadowParm.width = 0.015f;
        } else if (l2 < 800L) {
            this.mLinearShadowParm.alpha = 0.0f;
            this.mLinearShadowParm.stride = 0.03f;
            this.mLinearShadowParm.width = 0.024f;
        } else if (l2 < 900L) {
            this.mLinearShadowParm.alpha = 1.0f;
        } else if (l2 < 1000L) {
            this.mLinearShadowParm.alpha = 0.0f;
            this.mLinearShadowParm.stride = 0.03f;
            this.mLinearShadowParm.width = 0.015f;
        } else if (l2 < 1050L) {
            this.mLinearShadowParm.alpha = 0.0f;
            this.mLinearShadowParm.stride = 0.03f;
            this.mLinearShadowParm.width = 0.024f;
        } else if (l2 < 1100L) {
            this.mLinearShadowParm.alpha = 0.0f;
            this.mLinearShadowParm.stride = 0.03f;
            this.mLinearShadowParm.width = 0.015f;
        } else if (l2 < 1200L) {
            this.mLinearShadowParm.alpha = 0.0f;
            this.mLinearShadowParm.stride = 0.03f;
            this.mLinearShadowParm.width = 0.009f;
        } else if (l2 < 1500L) {
            this.mLinearShadowParm.alpha = 0.0f;
            this.mLinearShadowParm.stride = 0.03f;
            this.mLinearShadowParm.width = 0.003f;
        } else if (l2 < 2500L) {
            this.mLinearShadowParm.alpha = 1.0f;
        } else {
            this.mEffectStartTime = -1L;
        }
        TXCGPULinearShadowFilter tXCGPULinearShadowFilter = this;
        tXCGPULinearShadowFilter.setParamsInternal(tXCGPULinearShadowFilter.mLinearShadowParm.mode, this.mLinearShadowParm.alpha, this.mLinearShadowParm.offset, this.mLinearShadowParm.width, this.mLinearShadowParm.stride);
    }

    private void setParamsInternal(float mode, float alpha, float offset, float width, float stride) {
        TXCGPULinearShadowFilter tXCGPULinearShadowFilter = this;
        tXCGPULinearShadowFilter.setFloatOnDraw(tXCGPULinearShadowFilter.mModePos, mode);
        TXCGPULinearShadowFilter tXCGPULinearShadowFilter2 = this;
        tXCGPULinearShadowFilter2.setFloatOnDraw(tXCGPULinearShadowFilter2.mAlphaPos, alpha);
        TXCGPULinearShadowFilter tXCGPULinearShadowFilter3 = this;
        tXCGPULinearShadowFilter3.setFloatOnDraw(tXCGPULinearShadowFilter3.mCPos, -1.0f * offset);
        TXCGPULinearShadowFilter tXCGPULinearShadowFilter4 = this;
        tXCGPULinearShadowFilter4.setFloatOnDraw(tXCGPULinearShadowFilter4.mWithPos, width);
        TXCGPULinearShadowFilter tXCGPULinearShadowFilter5 = this;
        tXCGPULinearShadowFilter5.setFloatOnDraw(tXCGPULinearShadowFilter5.mStridePos, stride);
    }

    public static class LinearShadowParam
    extends TXCGPUEffectFilterBase.VideoEffectParams {
        public float mode = 0.0f;
        public float alpha = 0.0f;
        public float offset = 0.0f;
        public float width = 0.0f;
        public float stride = 0.05f;
    }
}

