/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc.videoprocessor.videoeffect.filter;

import com.tencent.ugc.videobase.frame.GLTexture;
import com.tencent.ugc.videobase.frame.GLTexturePool;
import com.tencent.ugc.videoprocessor.videoeffect.TXCGPUEffectFilterBase;
import com.tencent.ugc.videoprocessor.videoeffect.filter.TXCGPUDissolveBlendFilter;
import com.tencent.ugc.videoprocessor.videoeffect.filter.TXCSavePreFrameFilter;
import java.nio.FloatBuffer;

public class TXCGPUGhostShadowFilter
extends TXCGPUEffectFilterBase {
    private static final String TAG = "TXCGPUGhostShadowFilter";
    private TXCGPUDissolveBlendFilter mDissolveBlendFilter = null;
    private GhostShadowParam mGhostShadowParam = null;
    private TXCSavePreFrameFilter mSavePreFrameFilter = null;
    private GLTexturePool mGLTexturePool;

    @Override
    public void onInit(GLTexturePool texturePool) {
        super.onInit(texturePool);
        this.mGLTexturePool = texturePool;
        if (this.mDissolveBlendFilter == null) {
            this.mDissolveBlendFilter = new TXCGPUDissolveBlendFilter();
            this.mDissolveBlendFilter.initialize(texturePool);
        }
        if (this.mSavePreFrameFilter == null) {
            this.mSavePreFrameFilter = new TXCSavePreFrameFilter();
            this.mSavePreFrameFilter.initFilter(texturePool);
        }
    }

    @Override
    public void onOutputSizeChanged(int width, int height) {
        super.onOutputSizeChanged(width, height);
        if (this.mDissolveBlendFilter != null) {
            this.mDissolveBlendFilter.onOutputSizeChanged(width, height);
        }
        if (this.mSavePreFrameFilter != null) {
            this.mSavePreFrameFilter.onOutputSizeChanged(width, height);
        }
    }

    @Override
    public void onUninit() {
        super.onUninit();
        if (this.mDissolveBlendFilter != null) {
            this.mDissolveBlendFilter.uninitialize();
            this.mDissolveBlendFilter = null;
        }
        if (this.mSavePreFrameFilter != null) {
            this.mSavePreFrameFilter.destroy();
            this.mSavePreFrameFilter = null;
        }
    }

    @Override
    public void setNextFrameTimestamp(long pts) {
        super.setNextFrameTimestamp(pts);
        if (this.mGhostShadowParam == null) {
            this.mGhostShadowParam = new GhostShadowParam();
        }
        this.mGhostShadowParam.delayNumber = 5;
        this.mGhostShadowParam.shadowLevel = 1;
        this.mGhostShadowParam.mixLevel = 0.5f;
    }

    @Override
    public void onDraw(int inTextureId, GLTexture outTexture, FloatBuffer cubeCoordsBuffer, FloatBuffer textureCoordsBuffer) {
        if (!this.isInitialized()) {
            return;
        }
        this.runPendingOnDrawTasks();
        TXCGPUGhostShadowFilter tXCGPUGhostShadowFilter = this;
        if (!tXCGPUGhostShadowFilter.initParams(tXCGPUGhostShadowFilter.mGhostShadowParam)) {
            return;
        }
        GLTexture gLTexture = this.mGLTexturePool.obtain(this.mOutputSize.width, this.mOutputSize.height);
        boolean bl2 = false;
        if (this.mSavePreFrameFilter != null) {
            bl2 = this.mSavePreFrameFilter.onDrawToTexture(inTextureId, gLTexture, cubeCoordsBuffer, textureCoordsBuffer);
        }
        if (this.mDissolveBlendFilter != null) {
            if (bl2) {
                this.mDissolveBlendFilter.setSecondInputTexture(gLTexture.getId());
            }
            this.mDissolveBlendFilter.onDraw(inTextureId, outTexture, cubeCoordsBuffer, textureCoordsBuffer);
        }
        gLTexture.release();
    }

    private boolean initParams(GhostShadowParam param) {
        if (param == null) {
            return false;
        }
        if (this.mSavePreFrameFilter != null) {
            this.mSavePreFrameFilter.setSavePreFrameNumber(param.delayNumber);
        }
        return true;
    }

    public static class GhostShadowParam
    extends TXCGPUEffectFilterBase.VideoEffectParams {
        public int delayNumber = 5;
        public int shadowLevel = 1;
        public float mixLevel = 0.5f;
    }
}

