/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc.videoprocessor;

import android.content.Context;
import android.graphics.Bitmap;
import com.tencent.liteav.base.util.CommonUtil;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.base.util.l;
import com.tencent.liteav.videobase.base.GLConstants;
import com.tencent.ugc.preprocessor.BeautyProcessor;
import com.tencent.ugc.preprocessor.VideoPreprocessor;
import com.tencent.ugc.preprocessor.VideoPreprocessorListener;
import com.tencent.ugc.videobase.frame.GLTexturePool;
import com.tencent.ugc.videobase.frame.PixelFrame;
import com.tencent.ugc.videobase.utils.OpenGlUtils;
import com.tencent.ugc.videobase.videobase.ConvertParams;
import com.tencent.ugc.videoprocessor.VideoEffectProcessor;
import com.tencent.ugc.videoprocessor.VideoTransitionProcessor;
import com.tencent.ugc.videoprocessor.WatermarkProcessor;
import java.nio.FloatBuffer;

public class VideoProcessManager {
    private static final int IDENTITY = 100;
    private final String mTAG = "VideoProcessManager_" + this.hashCode();
    private final VideoEffectProcessor mVideoEffectProcessor;
    private final VideoTransitionProcessor mTransitionProcessor;
    private final WatermarkProcessor mWatermarkProcessor;
    private final VideoPreprocessor mVideoPreprocessor;
    private final FloatBuffer mNormalCubeVerticesBuffer;
    private final FloatBuffer mNormalTextureCoordsBuffer;
    private GLTexturePool mGLTexturePool;
    private IVideoProcessManagerListener mListener;
    private boolean mNeedProcess = false;
    private boolean mIsPreprocessorRegister = false;
    private VideoPreprocessorListener mVideoPreprocessorListener = new VideoPreprocessorListener(){

        @Override
        public final void didProcessFrame(int identity, PixelFrame pixelFrame) {
            Object object = pixelFrame.getGLContext();
            VideoProcessManager.this.processByVideoEffect(pixelFrame);
            CommonUtil.equals(object, pixelFrame.getGLContext());
        }
    };

    public VideoProcessManager(Context context, boolean isEnterpriseProEnabled) {
        BeautyProcessor beautyProcessor = new BeautyProcessor(context, isEnterpriseProEnabled);
        this.mVideoPreprocessor = new VideoPreprocessor(context, beautyProcessor);
        this.mVideoEffectProcessor = new VideoEffectProcessor(context);
        this.mTransitionProcessor = new VideoTransitionProcessor(context);
        this.mWatermarkProcessor = new WatermarkProcessor();
        beautyProcessor.setPerformanceMode(isEnterpriseProEnabled);
        this.mNormalCubeVerticesBuffer = OpenGlUtils.createNormalCubeVerticesBuffer();
        this.mNormalTextureCoordsBuffer = OpenGlUtils.createTextureCoordsBuffer(l.a, false, false);
    }

    public void initFilter(GLTexturePool texturePool, int width, int height) {
        this.mGLTexturePool = texturePool;
        this.mWatermarkProcessor.initialize(this.mGLTexturePool, width, height);
        this.mTransitionProcessor.initialize(this.mGLTexturePool);
        if (!this.mIsPreprocessorRegister) {
            ConvertParams convertParams = new ConvertParams(width, height);
            this.mVideoPreprocessor.registerVideoProcessedListener(100, convertParams, GLConstants.a.b, GLConstants.PixelFormatType.f, false, this.mVideoPreprocessorListener);
            this.mIsPreprocessorRegister = true;
        }
    }

    public void processByVideoEffect(PixelFrame pixelFrame) {
        PixelFrame pixelFrame2 = this.processByVideoEffectInner(pixelFrame);
        if (pixelFrame2 != null && this.mListener != null) {
            this.mListener.didProcessFrame(pixelFrame2);
            pixelFrame2.release();
        }
    }

    private PixelFrame processByVideoEffectInner(PixelFrame pixelFrame) {
        PixelFrame pixelFrame2;
        PixelFrame pixelFrame3 = pixelFrame;
        pixelFrame3.retain();
        if (this.mVideoEffectProcessor != null && this.mVideoEffectProcessor.getCurrentMotionType(pixelFrame3.getTimestamp()) == 1) {
            pixelFrame2 = this.applyTransitionFilterChain(pixelFrame3);
            if (pixelFrame2 != null) {
                pixelFrame3.release();
                pixelFrame3 = pixelFrame2;
            }
            if ((pixelFrame2 = this.applyMotionFilterChain(pixelFrame3)) != null) {
                pixelFrame3.release();
                pixelFrame3 = pixelFrame2;
            }
        } else {
            pixelFrame2 = this.applyMotionFilterChain(pixelFrame3);
            if (pixelFrame2 != null) {
                pixelFrame3.release();
                pixelFrame3 = pixelFrame2;
            }
            if ((pixelFrame2 = this.applyTransitionFilterChain(pixelFrame3)) != null) {
                pixelFrame3.release();
                pixelFrame3 = pixelFrame2;
            }
        }
        if ((pixelFrame2 = this.mWatermarkProcessor.process(pixelFrame3, this.mNormalCubeVerticesBuffer, this.mNormalTextureCoordsBuffer)) != null) {
            pixelFrame3.release();
            pixelFrame3 = pixelFrame2;
        }
        return pixelFrame3;
    }

    public void unInitFilter() {
        LiteavLog.i(this.mTAG, "unInitialize");
        if (this.mVideoEffectProcessor != null) {
            this.mVideoEffectProcessor.destroy();
        }
        if (this.mTransitionProcessor != null) {
            this.mTransitionProcessor.destroy();
        }
        if (this.mIsPreprocessorRegister) {
            this.mVideoPreprocessor.unregisterVideoProcessedListener(100, this.mVideoPreprocessorListener);
            this.mIsPreprocessorRegister = false;
        }
    }

    public void unInitialize() {
        LiteavLog.i(this.mTAG, "unInitialize");
        if (this.mVideoPreprocessor != null) {
            this.mVideoPreprocessor.uninitialize();
        }
    }

    public void setListener(IVideoProcessManagerListener listener) {
        this.mListener = listener;
    }

    public void processFrame(PixelFrame frame) {
        if (frame == null) {
            return;
        }
        int n2 = -1;
        if (this.mListener != null) {
            n2 = this.mListener.customProcessFrame(frame);
        }
        if (n2 > 0) {
            frame = new PixelFrame(frame);
            frame.setTextureId(n2);
        }
        if (this.mVideoPreprocessor == null || !this.mNeedProcess) {
            if (this.mListener != null) {
                this.mListener.didProcessFrame(frame);
            }
        } else {
            if (this.mWatermarkProcessor != null) {
                this.mVideoPreprocessor.setGaussianBlurLevel(this.mWatermarkProcessor.getBlurLevel() * 4.0f);
            } else {
                this.mVideoPreprocessor.setGaussianBlurLevel(0.0f);
            }
            this.mVideoPreprocessor.processFrame(frame);
        }
        if (n2 > 0) {
            frame.release();
        }
    }

    private PixelFrame applyMotionFilterChain(PixelFrame frame) {
        if (this.mVideoEffectProcessor != null) {
            return this.mVideoEffectProcessor.processFrame(frame, this.mNormalCubeVerticesBuffer, this.mNormalTextureCoordsBuffer, this.mGLTexturePool);
        }
        return null;
    }

    private PixelFrame applyTransitionFilterChain(PixelFrame frame) {
        if (this.mTransitionProcessor == null) {
            return null;
        }
        return this.mTransitionProcessor.applyTransitionFilter(frame, this.mNormalCubeVerticesBuffer, this.mNormalTextureCoordsBuffer);
    }

    public WatermarkProcessor getWatermarkProcessor() {
        this.mNeedProcess = true;
        return this.mWatermarkProcessor;
    }

    public VideoEffectProcessor getEffectProcessor() {
        this.mNeedProcess = true;
        return this.mVideoEffectProcessor;
    }

    public VideoTransitionProcessor getTransitionProcessor() {
        this.mNeedProcess = true;
        return this.mTransitionProcessor;
    }

    public void setBeautyFilter(int beautyLevel, int whiteningLevel) {
        this.mNeedProcess = true;
        BeautyProcessor beautyProcessor = this.mVideoPreprocessor.getBeautyProcessor();
        if (beautyProcessor != null) {
            beautyProcessor.setBeautyLevel((float)beautyLevel / 9.0f);
            beautyProcessor.setWhitenessLevel((float)whiteningLevel / 9.0f);
        }
    }

    public void setSpecialRatio(float specialRatio) {
        this.mNeedProcess = true;
        this.mVideoPreprocessor.setFilterMixLevel(specialRatio);
    }

    public void setFilter(Bitmap leftBitmap, float leftIntensity, Bitmap rightBitmap, float rightIntensity, float leftRatio) {
        this.mNeedProcess = true;
        this.mVideoPreprocessor.setFilterGroupImages(leftRatio, leftBitmap, leftIntensity, rightBitmap, rightIntensity);
    }

    public void setScaleType(GLConstants.GLScaleType scaleType) {
        if (scaleType == GLConstants.GLScaleType.b) {
            this.mWatermarkProcessor.setRenderMode(2);
        }
    }

    public void setOutputSize(int width, int height) {
        if (this.mWatermarkProcessor != null) {
            this.mWatermarkProcessor.setRenderTargetSize(width, height);
        }
    }

    public static interface IVideoProcessManagerListener {
        public void didProcessFrame(PixelFrame var1);

        public int customProcessFrame(PixelFrame var1);
    }
}

