/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc.videobase.yuv;

import android.opengl.GLES20;
import com.tencent.liteav.videobase.base.GLConstants;
import com.tencent.ugc.videobase.chain.TXCGPUImageFilter;
import com.tencent.ugc.videobase.frame.GLTexturePool;
import com.tencent.ugc.videobase.yuv.TXCYUVRGBConvertMatrix;
import com.tencent.ugc.videobase.yuv.e;
import com.tencent.ugc.videobase.yuv.f;

public class TXCGPUImageYUVOutputFilter
extends TXCGPUImageFilter {
    private int mUniformWidth;
    private int mUniformHeight;
    private int mUniformConvertMatrix;
    private int mUniformConvertOffset;

    public TXCGPUImageYUVOutputFilter(String vertexShader, String fragmentShader) {
        super(vertexShader, fragmentShader);
    }

    @Override
    public void onInit(GLTexturePool texturePool) {
        super.onInit(texturePool);
        this.mUniformWidth = GLES20.glGetUniformLocation((int)this.getProgramId(), (String)"width");
        this.mUniformHeight = GLES20.glGetUniformLocation((int)this.getProgramId(), (String)"height");
        this.mUniformConvertMatrix = GLES20.glGetUniformLocation((int)this.getProgramId(), (String)"convertMatrix");
        this.mUniformConvertOffset = GLES20.glGetUniformLocation((int)this.getProgramId(), (String)"offset");
    }

    @Override
    public void setColorFormat(GLConstants.ColorRange colorRange, GLConstants.ColorSpace colorSpace) {
        if (colorRange == this.mColorRange && colorSpace == this.mColorSpace) {
            return;
        }
        super.setColorFormat(colorRange, colorSpace);
        TXCGPUImageYUVOutputFilter tXCGPUImageYUVOutputFilter = this;
        tXCGPUImageYUVOutputFilter.runOnDraw(e.a(tXCGPUImageYUVOutputFilter));
    }

    @Override
    public void onOutputSizeChanged(int width, int height) {
        super.onOutputSizeChanged(width, height);
        TXCGPUImageYUVOutputFilter tXCGPUImageYUVOutputFilter = this;
        tXCGPUImageYUVOutputFilter.runOnDraw(f.a(tXCGPUImageYUVOutputFilter));
    }

    private float[] getConvertOffset() {
        switch (this.mColorRange) {
            case c: {
                return TXCYUVRGBConvertMatrix.TX_RGB_2_YUV_FULL_RANGE_OFFSET;
            }
        }
        return TXCYUVRGBConvertMatrix.TX_RGB_2_YUV_VIDEO_RANGE_OFFSET;
    }

    private float[] getConvertMatrix() {
        GLConstants.ColorSpace colorSpace = this.mColorSpace;
        if (this.mColorSpace == null || this.mColorSpace == GLConstants.ColorSpace.a) {
            colorSpace = GLConstants.ColorSpace.b;
        }
        GLConstants.ColorRange colorRange = this.mColorRange;
        if (this.mColorRange == null || this.mColorRange == GLConstants.ColorRange.a) {
            colorRange = GLConstants.ColorRange.b;
        }
        if (colorSpace == GLConstants.ColorSpace.b) {
            if (colorRange == GLConstants.ColorRange.b) {
                return TXCYUVRGBConvertMatrix.T_TX_RGB_2_YUV_601_VIDEO_RANGE_MATRIX;
            }
            if (colorRange == GLConstants.ColorRange.c) {
                return TXCYUVRGBConvertMatrix.T_TX_RGB_2_YUV_601_FULL_RANGE_MATRIX;
            }
        } else if (colorSpace == GLConstants.ColorSpace.c) {
            if (colorRange == GLConstants.ColorRange.b) {
                return TXCYUVRGBConvertMatrix.T_TX_RGB_2_YUV_709_VIDEO_RANGE_MATRIX;
            }
            if (colorRange == GLConstants.ColorRange.c) {
                return TXCYUVRGBConvertMatrix.T_TX_RGB_2_YUV_709_Full_RANGE_MATRIX;
            }
        }
        return TXCYUVRGBConvertMatrix.T_TX_RGB_2_YUV_601_VIDEO_RANGE_MATRIX;
    }

    static /* synthetic */ void lambda$onOutputSizeChanged$1(TXCGPUImageYUVOutputFilter this_) {
        GLES20.glUseProgram((int)this_.getProgramId());
        GLES20.glUniform1f((int)this_.mUniformWidth, (float)this_.mOutputSize.width);
        GLES20.glUniform1f((int)this_.mUniformHeight, (float)this_.mOutputSize.height);
        GLES20.glUniformMatrix3fv((int)this_.mUniformConvertMatrix, (int)1, (boolean)false, (float[])this_.getConvertMatrix(), (int)0);
        GLES20.glUniform3fv((int)this_.mUniformConvertOffset, (int)1, (float[])this_.getConvertOffset(), (int)0);
    }

    static /* synthetic */ void lambda$setColorFormat$0(TXCGPUImageYUVOutputFilter this_) {
        GLES20.glUniformMatrix3fv((int)this_.mUniformConvertMatrix, (int)1, (boolean)false, (float[])this_.getConvertMatrix(), (int)0);
        GLES20.glUniform3fv((int)this_.mUniformConvertOffset, (int)1, (float[])this_.getConvertOffset(), (int)0);
    }
}

