/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc.videobase.yuv;

import android.opengl.GLES20;
import com.tencent.liteav.videobase.base.GLConstants;
import com.tencent.ugc.videobase.frame.GLTexturePool;
import com.tencent.ugc.videobase.yuv.TXCGPUImageYUVInputFilter;
import com.tencent.ugc.videobase.yuv.TXCYUVRGBConvertMatrix;
import com.tencent.ugc.videobase.yuv.c;
import com.tencent.ugc.videobase.yuv.d;

public class TXCGPUImageNV12InputFilter
extends TXCGPUImageYUVInputFilter {
    private static final String NV21_RENDER_SHADER = "precision highp float;\nvarying highp vec2 textureCoordinate;\n\nuniform sampler2D inputImageTexture;\nuniform sampler2D uvTexture;\nuniform mat3 convertMatrix;\nuniform vec3 offset;\n\nvoid main()\n{\n    highp vec3 yuv;\n    highp vec3 rgb;\n\n    yuv.x = texture2D(inputImageTexture, textureCoordinate).r;\n    yuv.y = texture2D(uvTexture, textureCoordinate).r;\n    yuv.z = texture2D(uvTexture, textureCoordinate).a;\n    yuv += offset;\n    rgb = convertMatrix * yuv;\n\n    gl_FragColor = vec4(rgb, 1.0);\n}";
    private int mUniformConvertMatrix;
    private int mUniformConvertOffset;

    public TXCGPUImageNV12InputFilter() {
        super("attribute vec4 position;\nattribute vec4 inputTextureCoordinate;\nuniform mat4 textureTransform;\nvarying highp vec2 textureCoordinate;\nvoid main()\n{\n    gl_Position = position;\n    textureCoordinate = (textureTransform * inputTextureCoordinate).xy;\n}", NV21_RENDER_SHADER);
    }

    @Override
    public void onInit(GLTexturePool texturePool) {
        super.onInit(texturePool);
        this.mUniformConvertMatrix = GLES20.glGetUniformLocation((int)this.getProgramId(), (String)"convertMatrix");
        this.mUniformConvertOffset = GLES20.glGetUniformLocation((int)this.getProgramId(), (String)"offset");
        TXCGPUImageNV12InputFilter tXCGPUImageNV12InputFilter = this;
        tXCGPUImageNV12InputFilter.runOnDraw(c.a(tXCGPUImageNV12InputFilter));
    }

    @Override
    protected int getUvFormat() {
        return 6410;
    }

    @Override
    public void setColorFormat(GLConstants.ColorRange colorRange, GLConstants.ColorSpace colorSpace) {
        if (colorRange == this.mColorRange && colorSpace == this.mColorSpace) {
            return;
        }
        super.setColorFormat(colorRange, colorSpace);
        TXCGPUImageNV12InputFilter tXCGPUImageNV12InputFilter = this;
        tXCGPUImageNV12InputFilter.runOnDraw(d.a(tXCGPUImageNV12InputFilter));
    }

    private float[] getConvertOffset() {
        switch (this.mColorRange) {
            case c: {
                return TXCYUVRGBConvertMatrix.TX_YUV_2_RGB_FULL_RANGE_OFFSET;
            }
        }
        return TXCYUVRGBConvertMatrix.TX_YUV_2_RGB_VIDEO_RANGE_OFFSET;
    }

    private float[] getConvertMatrix() {
        GLConstants.ColorSpace colorSpace = this.mColorSpace;
        if (this.mColorSpace == null || this.mColorSpace == GLConstants.ColorSpace.a) {
            colorSpace = GLConstants.ColorSpace.b;
        }
        GLConstants.ColorRange colorRange = this.mColorRange;
        if (this.mColorRange == null || this.mColorRange == GLConstants.ColorRange.a) {
            colorRange = GLConstants.ColorRange.b;
        }
        if (colorSpace == GLConstants.ColorSpace.b) {
            if (colorRange == GLConstants.ColorRange.b) {
                return TXCYUVRGBConvertMatrix.TX_YUV_2_RGB_601_VIDEO_RANGE_MATRIX;
            }
            if (colorRange == GLConstants.ColorRange.c) {
                return TXCYUVRGBConvertMatrix.TX_YUV_2_RGB_601_FULL_RANGE_MATRIX;
            }
        } else if (colorSpace == GLConstants.ColorSpace.c) {
            if (colorRange == GLConstants.ColorRange.b) {
                return TXCYUVRGBConvertMatrix.TX_YUV_2_RGB_709_VIDEO_RANGE_MATRIX;
            }
            if (colorRange == GLConstants.ColorRange.c) {
                return TXCYUVRGBConvertMatrix.TX_YUV_2_RGB_709_FULL_RANGE_MATRIX;
            }
        }
        return TXCYUVRGBConvertMatrix.TX_YUV_2_RGB_601_VIDEO_RANGE_MATRIX;
    }

    static /* synthetic */ void lambda$setColorFormat$1(TXCGPUImageNV12InputFilter this_) {
        GLES20.glUniformMatrix3fv((int)this_.mUniformConvertMatrix, (int)1, (boolean)false, (float[])this_.getConvertMatrix(), (int)0);
        GLES20.glUniform3fv((int)this_.mUniformConvertOffset, (int)1, (float[])this_.getConvertOffset(), (int)0);
    }

    static /* synthetic */ void lambda$onInit$0(TXCGPUImageNV12InputFilter this_) {
        GLES20.glUseProgram((int)this_.getProgramId());
        GLES20.glUniform3fv((int)this_.mUniformConvertOffset, (int)1, (float[])this_.getConvertOffset(), (int)0);
        GLES20.glUniformMatrix3fv((int)this_.mUniformConvertMatrix, (int)1, (boolean)false, (float[])this_.getConvertMatrix(), (int)0);
    }
}

