/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc.videobase.videobase;

import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.base.util.l;
import com.tencent.liteav.videobase.base.GLConstants;
import com.tencent.ugc.videobase.chain.TXCGPUImageFilter;
import com.tencent.ugc.videobase.frame.GLTexture;
import com.tencent.ugc.videobase.frame.GLTexturePool;
import com.tencent.ugc.videobase.frame.PixelFrame;
import com.tencent.ugc.videobase.frame.PixelFrameRenderer;
import com.tencent.ugc.videobase.utils.OpenGlUtils;
import com.tencent.ugc.videobase.videobase.ConvertParams;
import com.tencent.ugc.videobase.videobase.a;
import com.tencent.ugc.videobase.yuv.TXCGPUImageRGBAToI420Filter;
import com.tencent.ugc.videobase.yuv.TXCGPUImageRGBAToI420NoDiv16Filter;
import com.tencent.ugc.videobase.yuv.TXCGPUImageRGBAToNV12Filter;
import com.tencent.ugc.videobase.yuv.TXCGPUImageRGBAToNV21Filter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class FrameConverter {
    private static final String TAG = "FrameConverter";
    private final Map<ConvertParams, a> mSameParamsConverts = new HashMap<ConvertParams, a>();
    private GLTexturePool mGLTexturePool;

    public void addListener(ConvertParams convertParams, GLConstants.a pixelBufferType, GLConstants.PixelFormatType pixelFormatType, int identity, FrameConvertListener listener) {
        block5: {
            a a2 = this.mSameParamsConverts.get(convertParams);
            if (a2 == null) {
                a2 = new a(convertParams);
                if (this.mGLTexturePool != null) {
                    a2.a(this.mGLTexturePool);
                }
                this.mSameParamsConverts.put(convertParams, a2);
            }
            FrameConvertListener frameConvertListener = listener;
            GLConstants.PixelFormatType pixelFormatType2 = pixelFormatType;
            GLConstants.a a3 = pixelBufferType;
            a a4 = a2;
            List<a.a> list = a4.e.get((Object)pixelFormatType2);
            if (list == null) {
                list = new ArrayList<a.a>();
                a4.e.put(pixelFormatType2, list);
            }
            for (a.a a5 : list) {
                if (a5.b != identity || a5.c != frameConvertListener) {
                    continue;
                }
                break block5;
            }
            list.add(new a.a(a3, identity, frameConvertListener));
        }
    }

    public void removeListener(int identity, FrameConvertListener listener) {
        ArrayList<ConvertParams> arrayList = new ArrayList<ConvertParams>();
        for (Map.Entry<ConvertParams, a> object : this.mSameParamsConverts.entrySet()) {
            object.getValue().a(identity, listener);
            if (!object.getValue().e.isEmpty()) continue;
            arrayList.add(object.getKey());
        }
        for (ConvertParams convertParams : arrayList) {
            a a2 = this.mSameParamsConverts.get(convertParams);
            if (a2 != null) {
                a2.a();
            }
            this.mSameParamsConverts.remove(convertParams);
        }
    }

    public void initialize(GLTexturePool glTexturePool) {
        this.mGLTexturePool = glTexturePool;
        Iterator<a> iterator = this.mSameParamsConverts.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().a(glTexturePool);
        }
    }

    public void processFrame(long timestamp, GLTexture texture) {
        if (this.mSameParamsConverts.size() <= 0) {
            LiteavLog.w(TAG, "process frame without SameParamsConverter.");
        }
        Iterator<a> iterator = this.mSameParamsConverts.values().iterator();
        while (iterator.hasNext()) {
            GLTexture gLTexture;
            block21: {
                TXCGPUImageFilter tXCGPUImageFilter;
                TXCGPUImageFilter tXCGPUImageFilter2;
                GLTexture gLTexture2;
                GLConstants.ColorSpace colorSpace;
                GLConstants.ColorRange colorRange;
                int n2;
                int n3;
                int n4;
                a a2;
                GLTexture gLTexture3;
                block23: {
                    TXCGPUImageFilter tXCGPUImageFilter3;
                    block24: {
                        a a3;
                        GLConstants.PixelFormatType pixelFormatType;
                        block22: {
                            int n5;
                            GLTexture gLTexture4 = texture;
                            a a4 = iterator.next();
                            if (!a4.h) continue;
                            int n6 = a4.d.width != 0 ? a4.d.width : gLTexture4.getWidth();
                            int n7 = n5 = a4.d.height != 0 ? a4.d.height : gLTexture4.getHeight();
                            if (gLTexture4.getWidth() == n6 && gLTexture4.getHeight() == n5 && a4.d.rotation == l.a && !a4.d.mirror) {
                                gLTexture = gLTexture4;
                                gLTexture.retain();
                            } else {
                                if (a4.g == null) {
                                    a4.g = new PixelFrameRenderer(n6, n5);
                                }
                                PixelFrame pixelFrame = gLTexture4.wrap(OpenGlUtils.getCurrentContext());
                                if (a4.d.rotation == l.b || a4.d.rotation == l.d) {
                                    pixelFrame.setWidth(gLTexture4.getHeight());
                                    pixelFrame.setHeight(gLTexture4.getWidth());
                                } else {
                                    pixelFrame.setWidth(gLTexture4.getWidth());
                                    pixelFrame.setHeight(gLTexture4.getHeight());
                                }
                                pixelFrame.setRotation(a4.d.rotation);
                                pixelFrame.setMirrorHorizontal(a4.d.mirror);
                                gLTexture = a4.j.obtain(n6, n5);
                                gLTexture.setColorFormat(pixelFrame.getColorRange(), pixelFrame.getColorSpace());
                                gLTexture.setMetaData(gLTexture4.getMetaData());
                                a4.g.renderFrame(pixelFrame, GLConstants.GLScaleType.a, gLTexture);
                                pixelFrame.release();
                            }
                            gLTexture3 = gLTexture;
                            a2 = a4;
                            PixelFrame pixelFrame = gLTexture3.wrap(OpenGlUtils.getCurrentContext());
                            pixelFrame.setMetaData(gLTexture3.getMetaData());
                            a2.a(pixelFrame, timestamp);
                            pixelFrame.release();
                            PixelFrame pixelFrame2 = a2.a(timestamp, gLTexture3, GLConstants.PixelFormatType.f);
                            if (pixelFrame2 != null) {
                                pixelFrame2.release();
                            }
                            n4 = -1;
                            for (n3 = 0; n3 < a.a.length; ++n3) {
                                if (!a2.e.containsKey((Object)a.a[n3])) continue;
                                n4 = n3;
                                break;
                            }
                            if (n4 < 0) break block21;
                            n3 = gLTexture3.getWidth();
                            n2 = gLTexture3.getHeight();
                            colorRange = gLTexture3.getColorRange();
                            colorSpace = gLTexture3.getColorSpace();
                            gLTexture2 = a2.j.obtain(n3, n2);
                            gLTexture2.setColorFormat(colorRange, colorSpace);
                            pixelFormatType = a.a[n4];
                            a3 = a2;
                            if (pixelFormatType != null) break block22;
                            tXCGPUImageFilter2 = null;
                            break block23;
                        }
                        tXCGPUImageFilter3 = a3.f.get((Object)pixelFormatType);
                        if (tXCGPUImageFilter3 != null) break block24;
                        switch (pixelFormatType) {
                            case a: {
                                if (a3.d.height % 16 == 0) {
                                    tXCGPUImageFilter3 = new TXCGPUImageRGBAToI420Filter();
                                    break;
                                }
                                tXCGPUImageFilter3 = new TXCGPUImageRGBAToI420NoDiv16Filter();
                                break;
                            }
                            case b: {
                                tXCGPUImageFilter3 = new TXCGPUImageRGBAToNV12Filter();
                                break;
                            }
                            case c: {
                                tXCGPUImageFilter3 = new TXCGPUImageRGBAToNV21Filter();
                                break;
                            }
                            default: {
                                tXCGPUImageFilter2 = null;
                                break block23;
                            }
                        }
                        tXCGPUImageFilter3.initialize(null);
                        tXCGPUImageFilter3.onOutputSizeChanged(a3.d.width, a3.d.height);
                        a3.f.put(pixelFormatType, tXCGPUImageFilter3);
                    }
                    tXCGPUImageFilter2 = tXCGPUImageFilter = tXCGPUImageFilter3;
                }
                if (tXCGPUImageFilter2 != null) {
                    OpenGlUtils.glViewport(0, 0, n3, n2);
                    tXCGPUImageFilter.setColorFormat(colorRange, colorSpace);
                    tXCGPUImageFilter.onDraw(gLTexture3.getId(), gLTexture2, a2.b, a2.c);
                    gLTexture2.setMetaData(gLTexture3.getMetaData());
                    PixelFrame pixelFrame = a2.a(timestamp, gLTexture2, a.a[n4]);
                    if (pixelFrame != null) {
                        gLTexture2.release();
                        Object object = pixelFrame.getPixelBufferType() == GLConstants.a.a ? pixelFrame.getBuffer() : (Object)pixelFrame.getData();
                        for (int i2 = n4 + 1; i2 < a.a.length; ++i2) {
                            int n8 = a2.a(a.a[i2], GLConstants.a.a);
                            int n9 = a2.a(a.a[i2], GLConstants.a.d);
                            PixelFrame pixelFrame3 = null;
                            if (n8 != 0) {
                                pixelFrame3 = a2.i.obtain(n3, n2, GLConstants.a.a, a.a[i2]);
                            } else if (n9 != 0) {
                                pixelFrame3 = a2.i.obtain(n3, n2, GLConstants.a.d, a.a[i2]);
                            }
                            if (pixelFrame3 == null || !pixelFrame3.isFrameDataValid()) continue;
                            pixelFrame3.setColorFormat(colorRange, colorSpace);
                            OpenGlUtils.convertYuvFormat(pixelFrame.getPixelFormatType(), object, pixelFrame3.getPixelFormatType(), pixelFrame3.getBuffer(), n3, n2);
                            pixelFrame3.setMetaData(gLTexture3.getMetaData());
                            a2.a(pixelFrame3, timestamp);
                            a2.a(timestamp, pixelFrame3, n8, n9);
                            pixelFrame3.release();
                        }
                        pixelFrame.release();
                    }
                }
            }
            gLTexture.release();
        }
    }

    public void uninitialize() {
        Iterator<a> iterator = this.mSameParamsConverts.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().a();
        }
    }

    public static interface FrameConvertListener {
        public void onFrameConverted(int var1, PixelFrame var2);
    }
}

