/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc.videobase.utils;

import android.opengl.GLES20;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.ugc.videobase.utils.OpenGlUtils;

public class Program {
    private static final String TAG = "Program";
    private final String mVertexShader;
    private final String mFragmentShader;

    public Program(String vertexShader, String fragmentShader) {
        this.mVertexShader = vertexShader;
        this.mFragmentShader = fragmentShader;
    }

    public int build() {
        Program program = this;
        int n2 = program.loadShader(program.mVertexShader, 35633);
        if (n2 == 0) {
            LiteavLog.e(TAG, "load vertex shader failed.");
            return -1;
        }
        Program program2 = this;
        int n3 = program2.loadShader(program2.mFragmentShader, 35632);
        if (n3 == 0) {
            LiteavLog.e(TAG, "load fragment shader failed.");
            GLES20.glDeleteShader((int)n2);
            return -1;
        }
        int n4 = GLES20.glCreateProgram();
        GLES20.glAttachShader((int)n4, (int)n2);
        GLES20.glAttachShader((int)n4, (int)n3);
        GLES20.glLinkProgram((int)n4);
        int[] nArray = new int[1];
        GLES20.glGetProgramiv((int)n4, (int)35714, (int[])nArray, (int)0);
        if (nArray[0] == 0) {
            LiteavLog.e(TAG, "link program failed. status: " + nArray[0]);
            GLES20.glDeleteShader((int)n2);
            GLES20.glDeleteShader((int)n3);
            GLES20.glDeleteProgram((int)n4);
            return -1;
        }
        GLES20.glDeleteShader((int)n2);
        GLES20.glDeleteShader((int)n3);
        return n4;
    }

    private int loadShader(String strSource, int iType) {
        int[] nArray = new int[1];
        int n2 = GLES20.glCreateShader((int)iType);
        GLES20.glShaderSource((int)n2, (String)strSource);
        GLES20.glCompileShader((int)n2);
        GLES20.glGetShaderiv((int)n2, (int)35713, (int[])nArray, (int)0);
        if (nArray[0] == 0) {
            OpenGlUtils.checkGlError("glCompileShader");
            GLES20.glDeleteShader((int)n2);
            return 0;
        }
        return n2;
    }
}

