/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc.videobase.utils;

import android.graphics.PointF;
import java.util.ArrayList;
import java.util.List;

public class FloatUtils {
    private static final float THRESHOLD = 1.0E-6f;

    public static boolean isEqual(float f1, float f2) {
        return Math.abs(f1 - f2) < 1.0E-6f;
    }

    public static boolean isEqual(double f1, double f2) {
        return Math.abs(f1 - f2) < (double)1.0E-6f;
    }

    public static List<PointF> convertFloatArrayToPointFList(float[] coordinates) {
        if (coordinates == null || (coordinates.length & 1) == 1) {
            return null;
        }
        int n2 = 0;
        ArrayList<PointF> arrayList = new ArrayList<PointF>();
        while (n2 < coordinates.length) {
            float f2 = coordinates[n2++];
            float f3 = coordinates[n2++];
            arrayList.add(new PointF(f2, f3));
        }
        return arrayList;
    }

    public static float[] convertPointFListToFloatArray(List<PointF> points) {
        if (points == null || points.isEmpty()) {
            return null;
        }
        int n2 = points.size();
        float[] fArray = new float[n2 * 2];
        for (int i2 = 0; i2 < n2; ++i2) {
            PointF pointF = points.get(i2);
            fArray[i2 * 2] = pointF.x;
            fArray[i2 * 2 + 1] = pointF.y;
        }
        return fArray;
    }
}

