/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc.videobase.utils;

import android.graphics.Bitmap;
import android.opengl.GLES20;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.ugc.videobase.frame.GLTexture;
import com.tencent.ugc.videobase.utils.OpenGlUtils;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class DebugUtils {
    private static final String TAG = "DebugUtils";

    public static String dump(float[] obj) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        float[] fArray = obj;
        int n2 = obj.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            float f2 = fArray[i2];
            stringBuilder.append(f2).append(", ");
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public static void saveImage(File outputFile, GLTexture glTexture, int width, int height) {
        OpenGlUtils.generateFrameBufferId();
        DebugUtils.saveImage(outputFile, glTexture.getId(), width, height);
    }

    public static void saveImage(File outputFile, int textureId, int width, int height) {
        int n2 = OpenGlUtils.generateFrameBufferId();
        OpenGlUtils.attachTextureToFrameBuffer(textureId, n2);
        OpenGlUtils.bindFramebuffer(36160, n2);
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(width * height * 4).order(ByteOrder.nativeOrder());
        GLES20.glReadPixels((int)0, (int)0, (int)width, (int)height, (int)6408, (int)5121, (Buffer)byteBuffer);
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        byteBuffer.position(0);
        bitmap.copyPixelsFromBuffer((Buffer)byteBuffer);
        DebugUtils.saveBmpToFile(bitmap, outputFile, Bitmap.CompressFormat.PNG);
        OpenGlUtils.bindFramebuffer(36160, 0);
        OpenGlUtils.detachTextureFromFrameBuffer(n2);
        OpenGlUtils.deleteFrameBuffer(n2);
    }

    public static String getStackAsComment() {
        String[] stringArray = DebugUtils.getStack(true).split("\n");
        StringBuilder stringBuilder = new StringBuilder();
        String[] stringArray2 = stringArray;
        int n2 = stringArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = stringArray2[i2];
            stringBuilder.append("// ").append(string).append("\n");
        }
        return stringBuilder.toString();
    }

    public static String getStack(boolean printLine) {
        StackTraceElement[] stackTraceElementArray = new Throwable().getStackTrace();
        if (stackTraceElementArray == null || stackTraceElementArray.length < 4) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 1; i2 < stackTraceElementArray.length; ++i2) {
            stringBuilder.append("[");
            stringBuilder.append(stackTraceElementArray[i2].getClassName());
            stringBuilder.append(":");
            stringBuilder.append(stackTraceElementArray[i2].getMethodName());
            if (printLine) {
                stringBuilder.append("(").append(stackTraceElementArray[i2].getLineNumber()).append(")]\n");
                continue;
            }
            stringBuilder.append("]\n");
        }
        return stringBuilder.toString();
    }

    public static boolean saveBmpToFile(Bitmap bmp, File file, Bitmap.CompressFormat format) {
        if (bmp == null || file == null) {
            LiteavLog.e(TAG, "bmp or file is null");
            return false;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        bmp.compress(format, 100, (OutputStream)byteArrayOutputStream);
        return DebugUtils.writeToFile(byteArrayOutputStream.toByteArray(), file);
    }

    public static boolean writeToFile(byte[] data, File file) {
        FileOutputStream fileOutputStream = null;
        boolean bl2 = false;
        try {
            fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(data);
            fileOutputStream.flush();
            bl2 = true;
        }
        catch (IOException iOException) {
            DebugUtils.closeQuietly(fileOutputStream);
        }
        catch (Throwable throwable) {
            DebugUtils.closeQuietly(fileOutputStream);
            throw throwable;
        }
        DebugUtils.closeQuietly(fileOutputStream);
        return bl2;
    }

    public static void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }
}

