/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc.videobase.frame;

import com.tencent.liteav.base.b.a;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.ugc.videobase.frame.IRecycler;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class RefCounted {
    private static final String TAG = "RefCounted";
    private static final a sThrottler = new a(TimeUnit.SECONDS.toMillis(1L));
    private String mStackTrace;
    private final IRecycler mRecycler;
    private final AtomicInteger mRefCnt = new AtomicInteger(0);
    private long mLastUsedTimestamp = -1L;

    public RefCounted(IRecycler recycler) {
        this.mRecycler = recycler;
    }

    public int retain() {
        this.mStackTrace = null;
        return this.mRefCnt.addAndGet(1);
    }

    public void release() {
        if (this.mRefCnt.decrementAndGet() == 0 && this.mRecycler != null) {
            this.mRecycler.recycle(this);
        }
    }

    public void updateLastUsedTimestamp(long timestamp) {
        this.mLastUsedTimestamp = timestamp;
    }

    public long getLastUsedTimestamp() {
        return this.mLastUsedTimestamp;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.mRecycler != null && this.mRefCnt.get() != 0) {
            LiteavLog.e(sThrottler, TAG, "Object's reference count(%d) isn't zero when finalize.\n retainTrack:%s", this.mRefCnt.get(), this.mStackTrace);
        }
    }
}

