/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc.videobase.frame;

import android.opengl.EGL14;
import android.opengl.EGLContext;
import android.opengl.EGLDisplay;
import android.opengl.EGLSurface;
import android.opengl.GLES20;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.b.b;
import com.tencent.liteav.base.util.CommonUtil;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.base.util.Size;
import com.tencent.liteav.videobase.base.GLConstants;
import com.tencent.ugc.videobase.egl.EGLCore;
import com.tencent.ugc.videobase.egl.EGLException;
import com.tencent.ugc.videobase.frame.GLTexture;
import com.tencent.ugc.videobase.frame.GLTexturePool;
import com.tencent.ugc.videobase.frame.PixelFrame;
import com.tencent.ugc.videobase.frame.PixelFrameRenderer;
import com.tencent.ugc.videobase.utils.MemoryAllocator;
import java.nio.ByteBuffer;

@JNINamespace(value="liteav::ugc")
public class PixelFrameFactory {
    private final String mTAG = "PixelFrameFactory_" + this.hashCode();
    private Object mSharedEGLContext = null;
    private EGLCore mRenderEGLCore;
    private EGLDisplay mCallerEGLDisplay = EGL14.EGL_NO_DISPLAY;
    private EGLContext mCallerEGLContext = EGL14.EGL_NO_CONTEXT;
    private EGLSurface mCallerEGLReadSurface = EGL14.EGL_NO_SURFACE;
    private EGLSurface mCallerEGLDrawSurface = EGL14.EGL_NO_SURFACE;
    private GLTexturePool mGLTexturePool;
    private PixelFrameRenderer mPixelFrameRenderer;
    private final Size mLastFrameSize = new Size();
    private final b mThrottlers = new b();

    public synchronized PixelFrame create(int width, int height, long timeStamp, int bufferType, int formatType, int textureId, Object eglContext, Object data, boolean isNeedCopyBuffer) {
        PixelFrame pixelFrame = new PixelFrame();
        pixelFrame.setWidth(width);
        pixelFrame.setHeight(height);
        pixelFrame.setTimestamp(timeStamp);
        pixelFrame.setGLContext(eglContext);
        pixelFrame.setTextureId(textureId);
        pixelFrame.setPixelBufferType(GLConstants.a.a(bufferType));
        pixelFrame.setPixelFormatType(GLConstants.PixelFormatType.a(formatType));
        pixelFrame = pixelFrame.getPixelBufferType() == GLConstants.a.d || pixelFrame.getPixelBufferType() == GLConstants.a.a ? (isNeedCopyBuffer ? this.deepCopyDataToPixelFrame(pixelFrame, data) : this.shallowCopyDataToPixelFrame(pixelFrame, data)) : this.deepCopyTextureToPixelFrame(pixelFrame, eglContext);
        return pixelFrame;
    }

    public synchronized void release(PixelFrame pixelFrame) {
        if (pixelFrame != null) {
            pixelFrame.release();
        }
    }

    public synchronized void uninitOpenGLComponents() {
        if (this.mRenderEGLCore == null) {
            return;
        }
        LiteavLog.i(this.mTAG, "uninitOpenGLComponents");
        if (this.makeCurrent()) {
            if (this.mGLTexturePool != null) {
                this.mGLTexturePool.evictAll();
                this.mGLTexturePool.destroy();
                this.mGLTexturePool = null;
            }
            if (this.mPixelFrameRenderer != null) {
                this.mPixelFrameRenderer.uninitialize();
                this.mPixelFrameRenderer = null;
            }
        }
        EGLCore.destroy(this.mRenderEGLCore);
        this.mRenderEGLCore = null;
    }

    private PixelFrame shallowCopyDataToPixelFrame(PixelFrame pixelFrame, Object data) {
        if (data instanceof byte[]) {
            pixelFrame.setData((byte[])data);
        } else if (data instanceof ByteBuffer) {
            pixelFrame.setBuffer((ByteBuffer)data);
        }
        pixelFrame.retain();
        return pixelFrame;
    }

    private PixelFrame deepCopyDataToPixelFrame(PixelFrame pixelFrame, Object data) {
        if (data instanceof byte[]) {
            byte[] byArray = MemoryAllocator.allocateByteArray(((byte[])data).length);
            if (byArray == null) {
                return null;
            }
            System.arraycopy(data, 0, byArray, 0, byArray.length);
            pixelFrame.setData(byArray);
        } else if (data instanceof ByteBuffer) {
            ByteBuffer byteBuffer = MemoryAllocator.allocateDirectBuffer(((ByteBuffer)data).capacity());
            if (byteBuffer == null) {
                return null;
            }
            ((ByteBuffer)data).rewind();
            byteBuffer.put((ByteBuffer)data);
            byteBuffer.rewind();
            pixelFrame.setBuffer(byteBuffer);
        }
        pixelFrame.retain();
        return pixelFrame;
    }

    private PixelFrame deepCopyTextureToPixelFrame(PixelFrame pixelFrame, Object sharedContext) {
        this.saveCallerEGLContext();
        GLES20.glFinish();
        if (!CommonUtil.equals(this.mSharedEGLContext, sharedContext)) {
            this.uninitOpenGLComponents();
            this.initRenderEGLContext(sharedContext);
        }
        if (!this.makeCurrent()) {
            LiteavLog.e(this.mThrottlers.a("makeCurrent"), this.mTAG, "use origin texture when makeCurrent error", new Object[0]);
            pixelFrame.retain();
            return pixelFrame;
        }
        pixelFrame = this.copyTexture(pixelFrame);
        GLES20.glFinish();
        this.restoreCallerEGLContext();
        return pixelFrame;
    }

    private void saveCallerEGLContext() {
        EGLContext eGLContext = EGL14.eglGetCurrentContext();
        if (CommonUtil.equals(this.mCallerEGLContext, EGL14.EGL_NO_CONTEXT) || !CommonUtil.equals(eGLContext, this.mCallerEGLContext)) {
            this.mCallerEGLContext = eGLContext;
            this.mCallerEGLDisplay = EGL14.eglGetCurrentDisplay();
            this.mCallerEGLReadSurface = EGL14.eglGetCurrentSurface((int)12378);
            this.mCallerEGLDrawSurface = EGL14.eglGetCurrentSurface((int)12377);
        }
    }

    private void restoreCallerEGLContext() {
        if (!CommonUtil.equals(this.mCallerEGLContext, EGL14.EGL_NO_CONTEXT)) {
            EGL14.eglMakeCurrent((EGLDisplay)this.mCallerEGLDisplay, (EGLSurface)this.mCallerEGLDrawSurface, (EGLSurface)this.mCallerEGLReadSurface, (EGLContext)this.mCallerEGLContext);
            return;
        }
        EGLSurface eGLSurface = EGL14.EGL_NO_SURFACE;
        EGL14.eglMakeCurrent((EGLDisplay)EGL14.eglGetCurrentDisplay(), (EGLSurface)eGLSurface, (EGLSurface)eGLSurface, (EGLContext)EGL14.EGL_NO_CONTEXT);
    }

    private PixelFrame copyTexture(PixelFrame pixelFrame) {
        if (this.mGLTexturePool == null) {
            this.mGLTexturePool = new GLTexturePool();
        }
        GLTexture gLTexture = this.mGLTexturePool.obtain(pixelFrame.getWidth(), pixelFrame.getHeight());
        gLTexture.setColorFormat(pixelFrame.getColorRange(), pixelFrame.getColorSpace());
        if (this.mLastFrameSize.width != pixelFrame.getWidth() || this.mLastFrameSize.height != pixelFrame.getHeight()) {
            if (this.mPixelFrameRenderer != null) {
                this.mPixelFrameRenderer.uninitialize();
                this.mPixelFrameRenderer = null;
            }
            this.mLastFrameSize.width = pixelFrame.getWidth();
            this.mLastFrameSize.height = pixelFrame.getHeight();
        }
        if (this.mPixelFrameRenderer == null) {
            this.mPixelFrameRenderer = new PixelFrameRenderer(pixelFrame.getWidth(), pixelFrame.getHeight());
        }
        this.mPixelFrameRenderer.renderFrame(pixelFrame, GLConstants.GLScaleType.c, gLTexture);
        pixelFrame = gLTexture.wrap(pixelFrame.getGLContext());
        gLTexture.release();
        return pixelFrame;
    }

    private void initRenderEGLContext(Object sharedContext) {
        if (this.mRenderEGLCore != null) {
            return;
        }
        LiteavLog.i(this.mTAG, "initRenderEGLContext");
        this.mSharedEGLContext = sharedContext;
        this.mRenderEGLCore = new EGLCore();
        try {
            this.mRenderEGLCore.initialize(sharedContext, null, 128, 128);
            return;
        }
        catch (EGLException eGLException) {
            this.mRenderEGLCore = null;
            LiteavLog.e(this.mThrottlers.a("initEGLCore"), this.mTAG, "create EGLCore failed.", eGLException);
            return;
        }
    }

    private boolean makeCurrent() {
        if (this.mRenderEGLCore == null) {
            LiteavLog.e(this.mThrottlers.a("makeCurrentNull"), this.mTAG, "makeCurrent on mEGLCore is null", new Object[0]);
            return false;
        }
        try {
            this.mRenderEGLCore.makeCurrent();
        }
        catch (EGLException eGLException) {
            LiteavLog.e(this.mThrottlers.a("makeCurrentError"), this.mTAG, "make current failed.", eGLException);
            return false;
        }
        return true;
    }
}

