/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc.videobase.frame;

import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.ugc.videobase.frame.IRecycler;
import com.tencent.ugc.videobase.frame.RefCounted;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.concurrent.Semaphore;

public abstract class LimitedFramePool<T extends RefCounted> {
    private static final String TAG = "LimitedFramePool";
    private final Deque<T> mDeque = new LinkedList<T>();
    private final Semaphore mSemaphore;
    private volatile boolean mIsDestroyed = false;
    private final IRecycler<T> mRecycler = new IRecycler<T>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void recycle(T obj) {
            if (obj == null) {
                return;
            }
            LimitedFramePool.this.mSemaphore.release();
            LimitedFramePool limitedFramePool = LimitedFramePool.this;
            synchronized (limitedFramePool) {
                if (LimitedFramePool.this.mIsDestroyed) {
                    LimitedFramePool.this.destroyInstance(obj);
                    return;
                }
                LimitedFramePool.this.mDeque.addFirst(obj);
                return;
            }
        }
    };

    protected LimitedFramePool(int maxCount) {
        this.mSemaphore = new Semaphore(maxCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T obtain() throws InterruptedException {
        RefCounted refCounted;
        this.mSemaphore.acquire();
        LimitedFramePool limitedFramePool = this;
        synchronized (limitedFramePool) {
            if (!this.mDeque.isEmpty()) {
                refCounted = (RefCounted)this.mDeque.removeFirst();
            } else {
                LimitedFramePool limitedFramePool2 = this;
                refCounted = limitedFramePool2.createInstance(limitedFramePool2.mRecycler);
            }
        }
        if (refCounted.retain() != 1) {
            LiteavLog.e(TAG, "invalid reference count for %s", refCounted);
        }
        return (T)refCounted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evictAll() {
        ArrayList<T> arrayList;
        LimitedFramePool limitedFramePool = this;
        synchronized (limitedFramePool) {
            arrayList = new ArrayList<T>(this.mDeque);
            this.mDeque.clear();
        }
        for (RefCounted refCounted : arrayList) {
            this.destroyInstance(refCounted);
        }
    }

    public void destroy() {
        this.mIsDestroyed = true;
        this.evictAll();
    }

    protected abstract T createInstance(IRecycler<T> var1);

    protected abstract void destroyInstance(T var1);
}

