/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc.videobase.frame;

import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.ugc.videobase.utils.OpenGlUtils;

public class GLFrameBuffer {
    private static final String TAG = "GLFrameBuffer";
    private int mFrameBufferId = -1;

    public void initialize() {
        if (this.mFrameBufferId == -1) {
            this.mFrameBufferId = OpenGlUtils.generateFrameBufferId();
        }
    }

    public void attachTexture(int textureId) {
        if (this.mFrameBufferId == -1) {
            LiteavLog.d(TAG, "FrameBuffer is invalid");
            return;
        }
        OpenGlUtils.attachTextureToFrameBuffer(textureId, this.mFrameBufferId);
    }

    public void bindToContext() {
        OpenGlUtils.bindFramebuffer(36160, this.mFrameBufferId);
    }

    public void unbindFromContext() {
        OpenGlUtils.bindFramebuffer(36160, 0);
    }

    public void detachTexture() {
        if (this.mFrameBufferId == -1) {
            LiteavLog.d(TAG, "FrameBuffer is invalid");
            return;
        }
        OpenGlUtils.detachTextureFromFrameBuffer(this.mFrameBufferId);
    }

    public void uninitialize() {
        if (this.mFrameBufferId != -1) {
            OpenGlUtils.deleteFrameBuffer(this.mFrameBufferId);
            this.mFrameBufferId = -1;
        }
    }
}

