/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc.videobase.egl;

import android.opengl.EGLContext;
import android.view.Surface;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.system.LiteavSystemInfo;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.base.util.Size;
import com.tencent.liteav.base.util.m;
import com.tencent.ugc.videobase.egl.EGL10Helper;
import com.tencent.ugc.videobase.egl.EGL14Helper;
import com.tencent.ugc.videobase.egl.EGLException;
import com.tencent.ugc.videobase.egl.EGLHelper;
import com.tencent.ugc.videobase.egl.a;
import java.util.concurrent.atomic.AtomicInteger;

@JNINamespace(value="liteav::ugc")
public class EGLCore {
    private static final String TAG = "EGLCore";
    private static final long DESTROY_EGL_CORE_DELAY_TIME_MS = 100L;
    private static final int MAX_EGL_CORE_COUNT = 50;
    private static final m sSequenceTaskRunner = new m();
    private static final AtomicInteger sEGLCoreCount = new AtomicInteger();
    private boolean mIsOffScreen = false;
    private EGLHelper<?> mEglHelper;

    public static EGLCore create(Object sharedGLContext) {
        EGLCore eGLCore = new EGLCore();
        try {
            eGLCore.initialize(sharedGLContext, null, 128, 128);
            eGLCore.makeCurrent();
        }
        catch (EGLException eGLException) {
            LiteavLog.e(TAG, "create EGLCore failed.", eGLException);
            eGLCore = null;
        }
        return eGLCore;
    }

    public static void destroy(EGLCore eglCore) {
        if (eglCore == null) {
            return;
        }
        eglCore.unmakeCurrent();
        Runnable runnable = a.a(eglCore);
        if (!eglCore.mIsOffScreen) {
            runnable.run();
            return;
        }
        sSequenceTaskRunner.b(runnable, 100L);
    }

    public static boolean makeCurrent(EGLCore eglCore) {
        try {
            if (eglCore != null) {
                eglCore.makeCurrent();
                return true;
            }
        }
        catch (EGLException eGLException) {
            LiteavLog.e(TAG, "make current failed. " + eGLException.getMessage());
        }
        return false;
    }

    public void initialize(Object sharedContext, Surface surface, int width, int height) throws EGLException {
        boolean bl2 = this.mIsOffScreen = surface == null;
        if (sharedContext == null) {
            this.mEglHelper = LiteavSystemInfo.getSystemOSVersionInt() >= 17 ? EGL14Helper.createEGLSurface(null, null, surface, width, height) : EGL10Helper.createEGLSurface(null, null, surface, width, height);
        } else if (sharedContext instanceof javax.microedition.khronos.egl.EGLContext) {
            this.mEglHelper = EGL10Helper.createEGLSurface(null, (javax.microedition.khronos.egl.EGLContext)sharedContext, surface, width, height);
        } else if (LiteavSystemInfo.getSystemOSVersionInt() >= 17 && sharedContext instanceof EGLContext) {
            this.mEglHelper = EGL14Helper.createEGLSurface(null, (EGLContext)sharedContext, surface, width, height);
        } else {
            throw new EGLException(0, "sharedContext isn't EGLContext");
        }
        int n2 = sEGLCoreCount.incrementAndGet();
        LiteavLog.i(TAG, "EGLCore created in thread " + Thread.currentThread().getId() + ", sharedContext: " + sharedContext + ", Surface: " + surface + ", width: " + width + ", height: " + height + ", eglCoreCount: " + n2);
    }

    public Size getSurfaceSize() {
        if (this.mEglHelper == null) {
            return new Size(0, 0);
        }
        return this.mEglHelper.getSurfaceSize();
    }

    public void makeCurrent() throws EGLException {
        if (this.mEglHelper != null) {
            this.mEglHelper.makeCurrent();
        }
    }

    public void unmakeCurrent() {
        if (this.mEglHelper != null) {
            this.mEglHelper.unmakeCurrent();
        }
    }

    public void swapBuffers() throws EGLException {
        if (this.mEglHelper != null) {
            this.mEglHelper.swapBuffers();
        }
    }

    public Object getEglContext() {
        if (this.mEglHelper == null) {
            return null;
        }
        return this.mEglHelper.getContext();
    }

    private void uninitialize() throws EGLException {
        if (this.mEglHelper != null) {
            this.mEglHelper.destroy();
            this.mEglHelper = null;
        }
        sEGLCoreCount.decrementAndGet();
    }

    static /* synthetic */ void lambda$destroy$0(EGLCore eglCore) {
        try {
            eglCore.uninitialize();
            LiteavLog.i(TAG, "EGLCore destroy success. ".concat(String.valueOf(eglCore)));
            return;
        }
        catch (EGLException eGLException) {
            LiteavLog.e(TAG, "EGLCore destroy failed.", eGLException);
            return;
        }
    }
}

