/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc.videobase.common;

import android.media.MediaFormat;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.videobase.common.CodecType;
import com.tencent.liteav.videobase.common.c;
import com.tencent.liteav.videobase.common.d;
import com.tencent.ugc.videobase.frame.HDRType;
import java.nio.ByteBuffer;

@JNINamespace(value="liteav::ugc")
public class EncodedVideoFrame {
    public static final int MATRIX_COEFFICIENTS_BT601 = 6;
    public static final int MATRIX_COEFFICIENTS_BT709 = 1;
    public ByteBuffer data;
    public c nalType = c.a;
    public d profileType = d.a;
    public CodecType codecType = CodecType.b;
    public int rotation;
    public long dts;
    public long pts;
    public int width;
    public int height;
    public int matrixCoefficients = 6;
    public HDRType hdrType = HDRType.NONE;
    public MediaFormat videoFormat;
    public boolean isEosFrame = false;

    public static EncodedVideoFrame create(int size) {
        EncodedVideoFrame encodedVideoFrame = new EncodedVideoFrame();
        new EncodedVideoFrame().data = ByteBuffer.allocateDirect(size);
        return encodedVideoFrame;
    }

    public boolean isIDRFrame() {
        return this.nalType != null && this.nalType.a();
    }

    public boolean isH265() {
        return this.codecType == CodecType.c;
    }

    public boolean isValidFrame() {
        return this.data != null && this.data.remaining() > 0 && this.nalType != null && this.codecType != null && this.width > 0 && this.height > 0;
    }

    public static int getNextNALHeaderPos(int startPos, ByteBuffer data) {
        int n2 = startPos;
        while (n2 + 3 < data.remaining()) {
            if (data.get(n2) == 0 && data.get(n2 + 1) == 0 && data.get(n2 + 2) == 0 && data.get(n2 + 3) == 1) {
                return n2 + 4;
            }
            if (data.get(n2) == 0 && data.get(n2 + 1) == 0 && data.get(n2 + 2) == 1) {
                return n2 + 3;
            }
            ++n2;
        }
        return -1;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setPTS(long pts) {
        this.pts = pts;
    }

    public void setDTS(long dts) {
        this.dts = dts;
    }

    public void setNalType(int nalType) {
        this.nalType = c.a(nalType);
    }

    public void setProfileType(int profileType) {
        this.profileType = d.a(profileType);
    }

    public void setCodecType(int codecType) {
        this.codecType = CodecType.a(codecType);
    }

    public void setRotation(int rotation) {
        this.rotation = rotation;
    }

    public void setEosFrame(boolean isEosFrame) {
        this.isEosFrame = isEosFrame;
    }

    public void setMatrixCoefficients(int matrixCoefficients) {
        this.matrixCoefficients = matrixCoefficients;
    }

    public void setHDRType(int hdrType) {
        this.hdrType = HDRType.valueOf(hdrType);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public long getPTS() {
        return this.pts;
    }

    public long getDTS() {
        return this.dts;
    }

    public int getNalType() {
        return this.nalType.mValue;
    }

    public int getProfileType() {
        return this.profileType.mValue;
    }

    public int getCodecType() {
        return this.codecType.mValue;
    }

    public int getRotation() {
        return this.rotation;
    }

    public ByteBuffer getData() {
        return this.data;
    }

    public MediaFormat getMediaFormat() {
        return this.videoFormat;
    }

    public boolean isEosFrame() {
        return this.isEosFrame;
    }

    public String toString() {
        return "nalType = " + (Object)((Object)this.nalType) + ", profileType=" + (Object)((Object)this.profileType) + ", rotation=" + this.rotation + ", codecType=" + (Object)((Object)this.codecType) + ", dts=" + this.dts + ", pts=" + this.pts + ", matrixCoefficients = " + this.matrixCoefficients + " ,hdrType = " + (Object)((Object)this.hdrType);
    }
}

