/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc.renderer;

import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.view.Surface;
import android.view.SurfaceView;
import android.view.TextureView;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.videobase.base.GLConstants;
import com.tencent.liteav.videobase.videobase.DisplayTarget;
import com.tencent.rtmp.ui.TXCloudVideoView;
import com.tencent.ugc.renderer.SurfaceRenderHelper;
import com.tencent.ugc.renderer.SurfaceViewRenderHelper;
import com.tencent.ugc.renderer.TextureViewRenderHelper;
import com.tencent.ugc.videobase.videobase.TXCCloudVideoViewMethodInvoker;

@JNINamespace(value="liteav::ugc")
public abstract class RenderViewHelperInterface {
    private static final String TAG = "RenderViewHelperInterface";

    public static RenderViewHelperInterface create(DisplayTarget displayTarget, RenderViewListener listener) {
        if (displayTarget == null || displayTarget.getType() == null) {
            LiteavLog.w(TAG, "displayTarget or type is null. displayTarget=".concat(String.valueOf(displayTarget)));
            return null;
        }
        SurfaceView surfaceView = null;
        TextureView textureView = null;
        Surface surface = null;
        TXCloudVideoView tXCloudVideoView = null;
        switch (displayTarget.getType()) {
            case b: {
                surfaceView = displayTarget.getSurfaceView();
                break;
            }
            case a: {
                textureView = displayTarget.getTextureView();
                break;
            }
            case c: {
                surface = displayTarget.getSurface();
                break;
            }
            case d: {
                tXCloudVideoView = displayTarget.getTXCloudVideoView();
                if (tXCloudVideoView == null) {
                    LiteavLog.w(TAG, "txCloudVideoView is null.");
                    break;
                }
                surfaceView = tXCloudVideoView.getSurfaceView();
                textureView = TXCCloudVideoViewMethodInvoker.getTextureViewSetByUser(tXCloudVideoView);
            }
        }
        if (surfaceView != null) {
            return new SurfaceViewRenderHelper(surfaceView, listener);
        }
        if (textureView != null) {
            return new TextureViewRenderHelper(textureView, listener);
        }
        if (surface != null) {
            return new SurfaceRenderHelper(surface, listener);
        }
        if (tXCloudVideoView != null) {
            return new TextureViewRenderHelper(tXCloudVideoView, listener);
        }
        LiteavLog.w(TAG, "RenderViewHelper not created. displayTarget=".concat(String.valueOf(displayTarget)));
        return null;
    }

    public abstract void updateVideoFrameInfo(GLConstants.GLScaleType var1, int var2, int var3, boolean var4);

    public abstract void release(boolean var1);

    public abstract Matrix getTransformMatrix(int var1, int var2);

    public abstract void checkViewAvailability();

    public abstract boolean isUsingTextureView();

    public static GLConstants.GLScaleType createScaleType(int scaleType) {
        return GLConstants.GLScaleType.a(scaleType);
    }

    public static interface RenderViewListener {
        public void onSurfaceChanged(Surface var1, boolean var2);

        public void onRequestRedraw(Bitmap var1);

        public void onSurfaceDestroy();
    }
}

