/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc.renderer;

import android.graphics.Matrix;
import android.graphics.PointF;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.base.util.Size;
import com.tencent.liteav.base.util.i;
import com.tencent.liteav.base.util.l;
import com.tencent.liteav.videobase.base.GLConstants;
import com.tencent.ugc.videobase.filter.TXCGPUImagePerspectiveCorrectionFilter;
import com.tencent.ugc.videobase.frame.GLTexture;
import com.tencent.ugc.videobase.frame.GLTexturePool;
import com.tencent.ugc.videobase.frame.PixelFrame;
import com.tencent.ugc.videobase.frame.PixelFrameRenderer;
import com.tencent.ugc.videobase.utils.OpenGlUtils;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.List;

public class PostProcessor {
    private final String mTAG = "PostProcessor_" + this.hashCode();
    private final Size mOutputSize = new Size();
    private final GLTexturePool mGLTexturePool;
    private TXCGPUImagePerspectiveCorrectionFilter mPerspectiveCorrectionFilter;
    private FloatBuffer mNormalCubeVerticesBuffer;
    private FloatBuffer mNormalTextureCoordsBuffer;
    private PixelFrameRenderer mPixelFrameRender;
    private Matrix mRenderViewTransformMatrix;
    private List<PointF> mPerspectiveCorrectionSrcViewPoints;
    private List<PointF> mPerspectiveCorrectionDstViewPoints;
    private boolean mNeedUpdatePerspectivePointsToFilter = false;

    public PostProcessor(GLTexturePool glTexturePool, int outputWidth, int outputHeight) {
        this.mGLTexturePool = glTexturePool;
        this.mOutputSize.set(outputWidth, outputHeight);
    }

    public void setOutputSize(int width, int height) {
        if (this.mOutputSize.width == width && this.mOutputSize.height == height) {
            return;
        }
        this.mOutputSize.set(width, height);
        this.mNeedUpdatePerspectivePointsToFilter = true;
    }

    public void setRenderViewTransformMatrix(Matrix matrix) {
        if (i.a(this.mRenderViewTransformMatrix, matrix)) {
            return;
        }
        this.mRenderViewTransformMatrix = matrix;
        this.mNeedUpdatePerspectivePointsToFilter = true;
    }

    public void setPerspectiveCorrectionPoints(List<PointF> srcViewPoints, List<PointF> dstViewPoints) {
        this.mPerspectiveCorrectionSrcViewPoints = srcViewPoints;
        this.mPerspectiveCorrectionDstViewPoints = dstViewPoints;
        this.mNeedUpdatePerspectivePointsToFilter = true;
    }

    private void setPerspectivePointsToFilter(List<PointF> srcViewPoints, List<PointF> dstViewPoints) {
        if (srcViewPoints == null || srcViewPoints.size() != 4 || dstViewPoints == null || dstViewPoints.size() != 4) {
            return;
        }
        if (!this.mOutputSize.isValid()) {
            return;
        }
        if (this.mPerspectiveCorrectionFilter != null) {
            List<PointF> list = this.reverseViewPointsToMappingGLPoints(srcViewPoints);
            List<PointF> list2 = this.reverseViewPointsToMappingGLPoints(dstViewPoints);
            this.mPerspectiveCorrectionFilter.setPerspectiveCorrectionPoints(list, list2);
        }
    }

    public void processFrame(PixelFrame pixelFrame, GLConstants.GLScaleType scaleType) {
        if (!this.mOutputSize.isValid()) {
            return;
        }
        if (this.mPixelFrameRender == null) {
            LiteavLog.i(this.mTAG, "create PixelFrameRenderer, size =" + this.mOutputSize);
            this.mPixelFrameRender = new PixelFrameRenderer(this.mOutputSize.width, this.mOutputSize.height);
        }
        OpenGlUtils.glViewport(0, 0, this.mOutputSize.width, this.mOutputSize.height);
        GLTexture gLTexture = this.mGLTexturePool.obtain(this.mOutputSize.width, this.mOutputSize.height);
        gLTexture.setColorFormat(pixelFrame.getColorRange(), pixelFrame.getColorSpace());
        this.mPixelFrameRender.setOutputSize(this.mOutputSize.width, this.mOutputSize.height);
        this.mPixelFrameRender.renderFrame(pixelFrame, scaleType, gLTexture);
        if (this.mPerspectiveCorrectionFilter == null) {
            this.initializePerspectiveCorrectionFilter();
        }
        if (this.mNeedUpdatePerspectivePointsToFilter) {
            PostProcessor postProcessor = this;
            postProcessor.setPerspectivePointsToFilter(postProcessor.mPerspectiveCorrectionSrcViewPoints, this.mPerspectiveCorrectionDstViewPoints);
            this.mNeedUpdatePerspectivePointsToFilter = false;
        }
        this.mPerspectiveCorrectionFilter.onDraw(gLTexture.getId(), null, this.mNormalCubeVerticesBuffer, this.mNormalTextureCoordsBuffer);
        gLTexture.release();
    }

    public void uninitialize() {
        this.uninitializePixelFrameRender();
        this.uninitializePerspectiveCorrectionFilter();
    }

    private void initializePerspectiveCorrectionFilter() {
        if (this.mPerspectiveCorrectionFilter != null) {
            return;
        }
        this.mPerspectiveCorrectionFilter = new TXCGPUImagePerspectiveCorrectionFilter();
        this.mPerspectiveCorrectionFilter.initialize(this.mGLTexturePool);
        if (this.mNormalCubeVerticesBuffer == null || this.mNormalTextureCoordsBuffer == null) {
            this.mNormalCubeVerticesBuffer = OpenGlUtils.createNormalCubeVerticesBuffer();
            this.mNormalTextureCoordsBuffer = OpenGlUtils.createTextureCoordsBuffer(l.a, false, false);
        }
    }

    private void uninitializePerspectiveCorrectionFilter() {
        if (this.mPerspectiveCorrectionFilter == null) {
            return;
        }
        this.mPerspectiveCorrectionFilter.uninitialize();
        this.mPerspectiveCorrectionFilter = null;
    }

    private List<PointF> reverseViewPointsToMappingGLPoints(List<PointF> points) {
        ArrayList<PointF> arrayList = new ArrayList<PointF>();
        for (PointF pointF : points) {
            float f2 = pointF.x * (float)this.mOutputSize.width;
            float f3 = pointF.y * (float)this.mOutputSize.height;
            PointF pointF2 = PostProcessor.reversePointWithTransformMatrix(new PointF(f2, f3), this.mRenderViewTransformMatrix);
            PointF pointF3 = new PointF(pointF2.x / (float)this.mOutputSize.width, pointF2.y / (float)this.mOutputSize.height);
            new PointF(pointF2.x / (float)this.mOutputSize.width, pointF2.y / (float)this.mOutputSize.height).y = 1.0f - pointF3.y;
            arrayList.add(pointF3);
        }
        return arrayList;
    }

    private void uninitializePixelFrameRender() {
        if (this.mPixelFrameRender != null) {
            this.mPixelFrameRender.uninitialize();
            this.mPixelFrameRender = null;
        }
    }

    private static PointF reversePointWithTransformMatrix(PointF point, Matrix matrix) {
        if (matrix == null) {
            return point;
        }
        Matrix matrix2 = new Matrix();
        if (!matrix.invert(matrix2)) {
            return point;
        }
        float[] fArray = new float[2];
        matrix2.mapPoints(fArray, new float[]{point.x, point.y});
        return new PointF(fArray[0], fArray[1]);
    }
}

